/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.wires.output;

import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.wires.output.internal.ForwardingOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class StandardOutputWire<OUT>
extends ForwardingOutputWire<OUT, OUT> {
    private final List<Consumer<OUT>> forwardingDestinations = new ArrayList<Consumer<OUT>>();

    public StandardOutputWire(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        super(model, name, uncaughtExceptionHandler);
    }

    @Override
    protected void addForwardingDestination(@NonNull Consumer<OUT> destination) {
        Objects.requireNonNull(destination);
        this.forwardingDestinations.add(destination);
    }

    @Override
    public void forward(@NonNull OUT data) {
        for (Consumer<OUT> destination : this.forwardingDestinations) {
            try {
                destination.accept(data);
            }
            catch (Exception e) {
                this.getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
        }
    }
}

