/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.model.internal.deterministic.DeterministicHeartbeatScheduler;
import com.swirlds.component.framework.model.internal.deterministic.DeterministicTaskSchedulerBuilder;
import com.swirlds.component.framework.schedulers.ExceptionHandlers;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerBuilder;
import com.swirlds.component.framework.wires.output.NoOpOutputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeterministicWiringModel
extends TraceableWiringModel {
    private final Metrics metrics;
    private List<Runnable> currentCycleWork = new ArrayList<Runnable>();
    private List<Runnable> nextCycleWork = new ArrayList<Runnable>();
    private final DeterministicHeartbeatScheduler heartbeatScheduler;
    private final Thread.UncaughtExceptionHandler taskSchedulerExceptionHandler;

    DeterministicWiringModel(@NonNull Metrics metrics, @NonNull Time time, @Nullable Thread.UncaughtExceptionHandler taskSchedulerExceptionHandler) {
        super(false);
        this.metrics = Objects.requireNonNull(metrics);
        this.heartbeatScheduler = new DeterministicHeartbeatScheduler(this, time);
        this.taskSchedulerExceptionHandler = taskSchedulerExceptionHandler;
    }

    public void tick() {
        for (Runnable work : this.currentCycleWork) {
            work.run();
        }
        this.heartbeatScheduler.tick();
        this.currentCycleWork = this.nextCycleWork;
        this.nextCycleWork = new ArrayList<Runnable>();
    }

    private void submitWork(@NonNull Runnable work) {
        this.nextCycleWork.add(work);
    }

    @Override
    @NonNull
    public <O> TaskSchedulerBuilder<O> schedulerBuilder(@NonNull String name) {
        DeterministicTaskSchedulerBuilder builder = new DeterministicTaskSchedulerBuilder(this.metrics, (TraceableWiringModel)this, name, this::submitWork);
        builder.withUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        return builder;
    }

    @Override
    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(@NonNull Duration period) {
        return this.heartbeatScheduler.buildHeartbeatWire(period, this.getUncaughtExceptionHandler());
    }

    @Override
    @NonNull
    public OutputWire<Duration> getHealthMonitorWire() {
        return new NoOpOutputWire<Duration>(this, "HealthMonitor");
    }

    @Override
    @NonNull
    public Duration getUnhealthyDuration() {
        return Duration.ZERO;
    }

    @Override
    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(double frequency) {
        return this.heartbeatScheduler.buildHeartbeatWire(frequency, this.getUncaughtExceptionHandler());
    }

    @NonNull
    private Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return Optional.ofNullable(this.taskSchedulerExceptionHandler).orElse(ExceptionHandlers.RETHROW_UNCAUGHT_EXCEPTION);
    }

    @Override
    public void start() {
        this.throwIfStarted();
        this.markAsStarted();
        this.heartbeatScheduler.start();
    }

    @Override
    public void stop() {
        this.throwIfNotStarted();
        this.heartbeatScheduler.stop();
    }
}

