/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.DeterministicWiringModel;
import com.swirlds.component.framework.model.StandardWiringModel;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;

public class WiringModelBuilder {
    private boolean deterministicModeEnabled;
    private ForkJoinPool defaultPool = ForkJoinPool.commonPool();
    private boolean healthMonitorEnabled = true;
    private boolean hardBackpressureEnabled = false;
    private boolean jvmAnchorEnabled = false;
    private int healthMonitorCapacity = 500;
    private Duration healthMonitorPeriod = Duration.ofMillis(100L);
    private Duration healthLogThreshold = Duration.ofSeconds(5L);
    private Duration healthLogPeriod = Duration.ofMinutes(10L);
    private final Metrics metrics;
    private final Time time;
    private Duration healthyReportThreshold = Duration.ofSeconds(1L);
    private Thread.UncaughtExceptionHandler taskSchedulerExceptionHandler = null;

    @NonNull
    public static WiringModelBuilder create(Metrics metrics, Time time) {
        return new WiringModelBuilder(metrics, time);
    }

    private WiringModelBuilder(@NonNull Metrics metrics, @NonNull Time time) {
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
    }

    @NonNull
    public WiringModelBuilder withDefaultPool(@NonNull ForkJoinPool defaultPool) {
        this.defaultPool = Objects.requireNonNull(defaultPool);
        return this;
    }

    @NonNull
    public WiringModelBuilder withDeterministicModeEnabled(boolean deterministicModeEnabled) {
        this.deterministicModeEnabled = deterministicModeEnabled;
        return this;
    }

    @NonNull
    public WiringModelBuilder withHealthMonitorEnabled(boolean healthMonitorEnabled) {
        this.healthMonitorEnabled = healthMonitorEnabled;
        return this;
    }

    @NonNull
    public WiringModelBuilder withHardBackpressureEnabled(boolean hardBackpressureEnabled) {
        this.hardBackpressureEnabled = hardBackpressureEnabled;
        return this;
    }

    @NonNull
    public WiringModelBuilder withJvmAnchorEnabled(boolean jvmAnchorEnabled) {
        this.jvmAnchorEnabled = jvmAnchorEnabled;
        return this;
    }

    @NonNull
    public WiringModelBuilder withHealthMonitorCapacity(int healthMonitorCapacity) {
        this.healthMonitorCapacity = healthMonitorCapacity;
        return this;
    }

    @NonNull
    public WiringModelBuilder withHealthMonitorPeriod(@NonNull Duration healthMonitorPeriod) {
        this.healthMonitorPeriod = Objects.requireNonNull(healthMonitorPeriod);
        return this;
    }

    @NonNull
    public WiringModelBuilder withHealthLogThreshold(@NonNull Duration healthThreshold) {
        this.healthLogThreshold = Objects.requireNonNull(healthThreshold);
        return this;
    }

    @NonNull
    public WiringModelBuilder withHealthLogPeriod(@NonNull Duration healthLogPeriod) {
        this.healthLogPeriod = Objects.requireNonNull(healthLogPeriod);
        return this;
    }

    @NonNull
    public WiringModelBuilder withHealthyReportThreshold(@NonNull Duration healthyReportThreshold) {
        this.healthyReportThreshold = Objects.requireNonNull(healthyReportThreshold);
        return this;
    }

    @NonNull
    public WiringModelBuilder withUncaughtExceptionHandler(@NonNull Thread.UncaughtExceptionHandler taskSchedulerExceptionHandler) {
        this.taskSchedulerExceptionHandler = Objects.requireNonNull(taskSchedulerExceptionHandler);
        return this;
    }

    @NonNull
    public <T extends WiringModel> T build() {
        if (this.deterministicModeEnabled) {
            return (T)new DeterministicWiringModel(this.metrics, this.time, this.taskSchedulerExceptionHandler);
        }
        return (T)new StandardWiringModel(this);
    }

    @NonNull
    ForkJoinPool getDefaultPool() {
        return this.defaultPool;
    }

    boolean isHealthMonitorEnabled() {
        return this.healthMonitorEnabled;
    }

    boolean isHardBackpressureEnabled() {
        return this.hardBackpressureEnabled;
    }

    boolean isJvmAnchorEnabled() {
        return this.jvmAnchorEnabled;
    }

    int getHealthMonitorCapacity() {
        return this.healthMonitorCapacity;
    }

    @NonNull
    Duration getHealthMonitorPeriod() {
        return this.healthMonitorPeriod;
    }

    @NonNull
    Duration getHealthLogThreshold() {
        return this.healthLogThreshold;
    }

    @NonNull
    Duration getHealthLogPeriod() {
        return this.healthLogPeriod;
    }

    @NonNull
    Metrics getMetrics() {
        return this.metrics;
    }

    @NonNull
    Time getTime() {
        return this.time;
    }

    @NonNull
    Duration getHealthyReportThreshold() {
        return this.healthyReportThreshold;
    }

    @NonNull
    Thread.UncaughtExceptionHandler getTaskSchedulerExceptionHandler() {
        return this.taskSchedulerExceptionHandler;
    }
}

