/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.monitor;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.internal.monitor.HealthMonitorLogger;
import com.swirlds.component.framework.model.internal.monitor.HealthMonitorMetrics;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.base.CompareTo;

public class HealthMonitor {
    private final List<TaskScheduler<?>> schedulers;
    private final List<Instant> lastHealthyTimes = new ArrayList<Instant>();
    private Duration previouslyReportedDuration = Duration.ZERO;
    private final HealthMonitorMetrics metrics;
    private final HealthMonitorLogger logger;
    private final AtomicReference<Duration> longestUnhealthyDuration = new AtomicReference<Duration>(Duration.ZERO);
    public final Duration healthyReportThreshold;
    private Instant lastHealthyTransitionTime = null;

    public HealthMonitor(@NonNull Metrics metrics, @NonNull Time time, @NonNull List<TaskScheduler<?>> schedulers, @NonNull Duration healthLogThreshold, @NonNull Duration healthLogPeriod, @NonNull Duration healthyReportThreshold) {
        this.metrics = new HealthMonitorMetrics(metrics, healthLogThreshold);
        this.schedulers = new ArrayList();
        this.healthyReportThreshold = healthyReportThreshold;
        for (TaskScheduler<?> scheduler : schedulers) {
            if (scheduler.getCapacity() == -1L) continue;
            this.schedulers.add(Objects.requireNonNull(scheduler));
            this.lastHealthyTimes.add(null);
        }
        this.logger = new HealthMonitorLogger(time, this.schedulers, healthLogThreshold, healthLogPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Duration checkSystemHealth(@NonNull Instant now) {
        Duration longestUnhealthyDuration = Duration.ZERO;
        for (int i = 0; i < this.lastHealthyTimes.size(); ++i) {
            boolean healthy;
            TaskScheduler<?> scheduler = this.schedulers.get(i);
            boolean bl = healthy = scheduler.getUnprocessedTaskCount() <= scheduler.getCapacity();
            if (healthy) {
                this.lastHealthyTimes.set(i, null);
                continue;
            }
            if (this.lastHealthyTimes.get(i) == null) {
                this.lastHealthyTimes.set(i, now);
            }
            Duration unhealthyDuration = Duration.between(this.lastHealthyTimes.get(i), now);
            this.logger.reportUnhealthyScheduler(scheduler, unhealthyDuration);
            if (!CompareTo.isGreaterThan((Comparable)unhealthyDuration, (Object)longestUnhealthyDuration)) continue;
            longestUnhealthyDuration = unhealthyDuration;
        }
        try {
            if (!longestUnhealthyDuration.equals(this.previouslyReportedDuration)) {
                this.longestUnhealthyDuration.set(longestUnhealthyDuration);
                this.metrics.reportUnhealthyDuration(longestUnhealthyDuration);
                if (longestUnhealthyDuration.isZero()) {
                    this.lastHealthyTransitionTime = now;
                }
                Duration duration = longestUnhealthyDuration;
                return duration;
            }
            if (longestUnhealthyDuration.isZero() && (Objects.isNull(this.lastHealthyTransitionTime) || CompareTo.isGreaterThanOrEqualTo((Comparable)Duration.between(this.lastHealthyTransitionTime, now), (Object)this.healthyReportThreshold))) {
                this.lastHealthyTransitionTime = now;
                Duration duration = longestUnhealthyDuration;
                return duration;
            }
            Duration duration = null;
            return duration;
        }
        finally {
            this.previouslyReportedDuration = longestUnhealthyDuration;
        }
    }

    @NonNull
    public Duration getUnhealthyDuration() {
        return this.longestUnhealthyDuration.get();
    }
}

