/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.PlatformCli;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.recovery.emergencyfile.EmergencyRecoveryFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="validate-manifest-file", mixinStandardHelpOptions=true, description={"Validate whether an emergency recovery file is well formed and has the necessary information"})
@SubcommandOf(value=PlatformCli.class)
public class ValidateManifestFileCommand
extends AbstractCommand {
    private static final Logger logger = LogManager.getLogger(ValidateManifestFileCommand.class);
    private Path dir;

    @CommandLine.Parameters(description={"the path to dir containing manifest file which should be named emergencyRecovery.yaml"})
    private void setDir(Path dir) {
        this.pathMustExist(dir);
        this.dir = dir;
    }

    @NonNull
    public Integer call() throws IOException {
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
        StateConfig stateConfig = (StateConfig)configuration.getConfigData(StateConfig.class);
        EmergencyRecoveryFile.read(stateConfig, this.dir, true);
        logger.info(LogMarker.CLI.getMarker(), "The emergency recovery file is well formed and has the necessary information.");
        return 0;
    }
}

