/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public enum TokenKey {
    ADMIN_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasAdminKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasAdminKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.adminKey(TokenKey.getNewKeyValue(update.adminKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.adminKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.adminKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_ADMIN_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_ADMIN_KEY;
        }
    }
    ,
    FEE_SCHEDULE_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasFeeScheduleKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasFeeScheduleKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.feeScheduleKey(TokenKey.getNewKeyValue(update.feeScheduleKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.feeScheduleKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.feeScheduleKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_FEE_SCHEDULE_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY;
        }
    }
    ,
    SUPPLY_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasSupplyKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasSupplyKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.supplyKey(TokenKey.getNewKeyValue(update.supplyKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.supplyKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.supplyKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_SUPPLY_KEY;
        }
    }
    ,
    WIPE_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasWipeKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasWipeKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.wipeKey(TokenKey.getNewKeyValue(update.wipeKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.wipeKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.wipeKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_WIPE_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_WIPE_KEY;
        }
    }
    ,
    PAUSE_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasPauseKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasPauseKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.pauseKey(TokenKey.getNewKeyValue(update.pauseKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.pauseKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.pauseKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_PAUSE_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_PAUSE_KEY;
        }
    }
    ,
    FREEZE_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasFreezeKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasFreezeKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.freezeKey(TokenKey.getNewKeyValue(update.freezeKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.freezeKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.freezeKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_FREEZE_KEY;
        }
    }
    ,
    KYC_KEY{

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasKycKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasKycKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.kycKey(TokenKey.getNewKeyValue(update.kycKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.kycKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.kycKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_KYC_KEY;
        }

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_KYC_KEY;
        }
    }
    ,
    METADATA_KEY{

        @Override
        public ResponseCodeEnum invalidKeyStatus() {
            return ResponseCodeEnum.INVALID_METADATA_KEY;
        }

        @Override
        public boolean isPresentInUpdate(TokenUpdateTransactionBody update) {
            return update.hasMetadataKey();
        }

        @Override
        public boolean isPresentInitially(Token originalToken) {
            return originalToken.hasMetadataKey();
        }

        @Override
        public void setOn(Token.Builder builder, TokenUpdateTransactionBody update) {
            builder.metadataKey(TokenKey.getNewKeyValue(update.metadataKey()));
        }

        @Override
        public Key getFromUpdate(TokenUpdateTransactionBody update) {
            return update.metadataKey();
        }

        @Override
        public Key getFromToken(Token originalToken) {
            return originalToken.metadataKey();
        }

        @Override
        public ResponseCodeEnum tokenHasNoKeyStatus() {
            return ResponseCodeEnum.TOKEN_HAS_NO_METADATA_KEY;
        }
    };


    public abstract boolean isPresentInUpdate(TokenUpdateTransactionBody var1);

    public abstract boolean isPresentInitially(Token var1);

    public abstract void setOn(Token.Builder var1, TokenUpdateTransactionBody var2);

    public abstract Key getFromUpdate(TokenUpdateTransactionBody var1);

    @Nullable
    public abstract Key getFromToken(Token var1);

    public abstract ResponseCodeEnum tokenHasNoKeyStatus();

    public abstract ResponseCodeEnum invalidKeyStatus();

    public boolean containsKeyRemoval(@NonNull TokenUpdateTransactionBody update) {
        if (this.isPresentInUpdate(update)) {
            return AttributeValidator.isKeyRemoval((Key)this.getFromUpdate(update));
        }
        return false;
    }

    public void updateKey(@NonNull TokenUpdateTransactionBody update, @NonNull Token originalToken, @NonNull Token.Builder builder) {
        if (this.isPresentInUpdate(update)) {
            HandleException.validateTrue((boolean)this.isPresentInitially(originalToken), (ResponseCodeEnum)this.tokenHasNoKeyStatus());
            this.setOn(builder, update);
        }
    }

    private static Key getNewKeyValue(Key newKey) {
        return AttributeValidator.isKeyRemoval((Key)newKey) ? null : newKey;
    }
}

