/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hederaaccountnumalias;

import com.esaulpaugh.headlong.abi.Address;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.hederaaccountnumalias.HederaAccountNumAliasCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HederaAccountNumAliasTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod HEDERA_ACCOUNT_NUM_ALIAS = SystemContractMethod.declare("getHederaAccountNumAlias(address)", "(int64,address)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALIASES);

    @Inject
    public HederaAccountNumAliasTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(HEDERA_ACCOUNT_NUM_ALIAS);
    }

    @NonNull
    public HederaAccountNumAliasCall callFrom(@NonNull HasCallAttempt attempt) {
        Address address = (Address)HEDERA_ACCOUNT_NUM_ALIAS.decodeCall(attempt.input().toArrayUnsafe()).get(0);
        return new HederaAccountNumAliasCall(attempt, address);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        return attempt.isMethod(HEDERA_ACCOUNT_NUM_ALIAS);
    }
}

