/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;

public final class SchedulingUtility {
    private SchedulingUtility() {
    }

    @NonNull
    public static SchedulableTransactionBody ordinaryChildAsSchedulable(@NonNull TransactionBody transactionBody) {
        SchedulableTransactionBody.Builder schedulableTransactionBody = SchedulableTransactionBody.newBuilder();
        switch ((TransactionBody.DataOneOfType)transactionBody.data().kind()) {
            case CRYPTO_CREATE_ACCOUNT: {
                schedulableTransactionBody.cryptoCreateAccount(transactionBody.cryptoCreateAccountOrThrow());
                break;
            }
            case CRYPTO_UPDATE_ACCOUNT: {
                schedulableTransactionBody.cryptoUpdateAccount(transactionBody.cryptoUpdateAccountOrThrow());
                break;
            }
            case CRYPTO_TRANSFER: {
                schedulableTransactionBody.cryptoTransfer(transactionBody.cryptoTransferOrThrow());
                break;
            }
            case CRYPTO_DELETE: {
                schedulableTransactionBody.cryptoDelete(transactionBody.cryptoDeleteOrThrow());
                break;
            }
            case CONTRACT_CALL: {
                schedulableTransactionBody.contractCall(transactionBody.contractCallOrThrow());
                break;
            }
            case FREEZE: {
                schedulableTransactionBody.freeze(transactionBody.freezeOrThrow());
                break;
            }
            case TOKEN_CREATION: {
                schedulableTransactionBody.tokenCreation(transactionBody.tokenCreationOrThrow());
                break;
            }
            case TOKEN_FREEZE: {
                schedulableTransactionBody.tokenFreeze(transactionBody.tokenFreezeOrThrow());
                break;
            }
            case TOKEN_UNFREEZE: {
                schedulableTransactionBody.tokenUnfreeze(transactionBody.tokenUnfreezeOrThrow());
                break;
            }
            case TOKEN_GRANT_KYC: {
                schedulableTransactionBody.tokenGrantKyc(transactionBody.tokenGrantKycOrThrow());
                break;
            }
            case TOKEN_REVOKE_KYC: {
                schedulableTransactionBody.tokenRevokeKyc(transactionBody.tokenRevokeKycOrThrow());
                break;
            }
            case TOKEN_DELETION: {
                schedulableTransactionBody.tokenDeletion(transactionBody.tokenDeletionOrThrow());
                break;
            }
            case TOKEN_UPDATE: {
                schedulableTransactionBody.tokenUpdate(transactionBody.tokenUpdateOrThrow());
                break;
            }
            case TOKEN_MINT: {
                schedulableTransactionBody.tokenMint(transactionBody.tokenMintOrThrow());
                break;
            }
            case TOKEN_BURN: {
                schedulableTransactionBody.tokenBurn(transactionBody.tokenBurnOrThrow());
                break;
            }
            case TOKEN_WIPE: {
                schedulableTransactionBody.tokenWipe(transactionBody.tokenWipeOrThrow());
                break;
            }
            case TOKEN_ASSOCIATE: {
                schedulableTransactionBody.tokenAssociate(transactionBody.tokenAssociateOrThrow());
                break;
            }
            case TOKEN_DISSOCIATE: {
                schedulableTransactionBody.tokenDissociate(transactionBody.tokenDissociateOrThrow());
                break;
            }
            case TOKEN_PAUSE: {
                schedulableTransactionBody.tokenPause(transactionBody.tokenPauseOrThrow());
                break;
            }
            case TOKEN_UNPAUSE: {
                schedulableTransactionBody.tokenUnpause(transactionBody.tokenUnpauseOrThrow());
                break;
            }
            case CRYPTO_APPROVE_ALLOWANCE: {
                schedulableTransactionBody.cryptoApproveAllowance(transactionBody.cryptoApproveAllowanceOrThrow());
                break;
            }
            case CRYPTO_DELETE_ALLOWANCE: {
                schedulableTransactionBody.cryptoDeleteAllowance(transactionBody.cryptoDeleteAllowanceOrThrow());
                break;
            }
            case TOKEN_FEE_SCHEDULE_UPDATE: {
                schedulableTransactionBody.tokenFeeScheduleUpdate(transactionBody.tokenFeeScheduleUpdateOrThrow());
                break;
            }
            case UTIL_PRNG: {
                schedulableTransactionBody.utilPrng(transactionBody.utilPrngOrThrow());
                break;
            }
            case TOKEN_REJECT: {
                schedulableTransactionBody.tokenReject(transactionBody.tokenRejectOrThrow());
                break;
            }
            default: {
                throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION);
            }
        }
        return schedulableTransactionBody.build();
    }
}

