/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.tuweni.units.bigints.UInt256;

public class StorageAccessTracker {
    private static final Function<ContractID, Map<UInt256, StorageAccess>> MAP_FACTORY = ignored -> new TreeMap();
    private final Map<ContractID, Map<UInt256, StorageAccess>> accessesByContract = new TreeMap<ContractID, Map<UInt256, StorageAccess>>(HapiUtils.CONTRACT_ID_COMPARATOR);

    public void trackIfFirstRead(ContractID contractID, @NonNull UInt256 key, @NonNull UInt256 value) {
        this.accessesByContract.computeIfAbsent(contractID, MAP_FACTORY).putIfAbsent(key, StorageAccess.newRead(key, value));
    }

    public List<StorageAccesses> getJustReads() {
        return this.getReadsMergedWith(List.of());
    }

    public List<StorageAccesses> getReadsMergedWith(@NonNull List<StorageAccesses> writes) {
        writes.forEach(scoped -> {
            Map<UInt256, StorageAccess> reads = this.accessesByContract.computeIfAbsent(scoped.contractID(), MAP_FACTORY);
            scoped.accesses().forEach(write -> reads.put(write.key(), (StorageAccess)write));
        });
        ArrayList<StorageAccesses> allAccesses = new ArrayList<StorageAccesses>();
        this.accessesByContract.forEach((contract, accesses) -> {
            ArrayList<StorageAccess> scopedAccesses = new ArrayList<StorageAccess>(accesses.values());
            allAccesses.add(new StorageAccesses((ContractID)contract, (List<StorageAccess>)scopedAccesses));
        });
        return allAccesses;
    }
}

