/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.fee;

import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hederahashgraph.api.proto.java.CryptoCreateTransactionBody;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class CryptoFeeBuilder
extends FeeBuilder {
    @Inject
    public CryptoFeeBuilder() {
    }

    public static FeeData getCryptoCreateTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        CryptoCreateTransactionBody cryptoCreate = txBody.getCryptoCreateAccount();
        int cryptoCreateSize = CryptoFeeBuilder.getCryptoCreateAccountBodyTxSize(cryptoCreate);
        long bpt = txBodySize + (long)cryptoCreateSize + (long)sigValObj.getSignatureSize();
        long vpt = sigValObj.getTotalSigCount();
        long rbs = CryptoFeeBuilder.getCryptoRbs(cryptoCreate, cryptoCreateSize) + CryptoFeeBuilder.calculateRbs(txBody);
        long rbsNetwork = CryptoFeeBuilder.getDefaultRbhNetworkSize() + 4320L;
        long bpr = 4L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(0L).setGas(0L).setTv(0L).setBpr(4L).setSbpr(0L).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getCryptoDeleteTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) {
        long bpr = 4L;
        long txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        long bpt = txBodySize + 48L + (long)sigValObj.getSignatureSize();
        long vpt = sigValObj.getTotalSigCount();
        long rbs = CryptoFeeBuilder.calculateRbs(txBody);
        long rbsNetwork = CryptoFeeBuilder.getDefaultRbhNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(0L).setGas(0L).setTv(0L).setBpr(4L).setSbpr(0L).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    private static long getCryptoRbs(CryptoCreateTransactionBody cryptoCreate, int crCreateSize) {
        long seconds = cryptoCreate.hasAutoRenewPeriod() ? cryptoCreate.getAutoRenewPeriod().getSeconds() : 0L;
        return (long)crCreateSize * seconds;
    }

    private static int getCryptoCreateAccountBodyTxSize(CryptoCreateTransactionBody cryptoCreate) {
        int keySize = CryptoFeeBuilder.getAccountKeyStorageSize(cryptoCreate.getKey());
        int newRealmAdminKeySize = cryptoCreate.hasNewRealmAdminKey() ? CryptoFeeBuilder.getAccountKeyStorageSize(cryptoCreate.getNewRealmAdminKey()) : 0;
        return keySize + 68 + newRealmAdminKeySize;
    }

    public static FeeData getCostTransactionRecordQueryFeeMatrices() {
        return FeeData.getDefaultInstance();
    }

    public FeeData getTransactionRecordQueryFeeMatrices(TransactionRecord transRecord, ResponseType responseType) {
        if (transRecord == null) {
            return FeeData.getDefaultInstance();
        }
        long bpt = 244L;
        int txRecordSize = CryptoFeeBuilder.getAccountTransactionRecordSize(transRecord);
        long bpr = 16L + (long)txRecordSize + (long)CryptoFeeBuilder.getStateProofSize(responseType);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(244L).setVpt(0L).setRbh(0L).setSbh(0L).setGas(0L).setTv(0L).setBpr(bpr).setSbpr(0L).build();
        return CryptoFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getCryptoAccountRecordsQueryFeeMatrices(List<TransactionRecord> transRecords, ResponseType responseType) {
        long bpt = 244L;
        int txRecordListsize = 0;
        if (transRecords != null) {
            for (TransactionRecord transRecord : transRecords) {
                txRecordListsize += CryptoFeeBuilder.getAccountTransactionRecordSize(transRecord);
            }
        }
        long bpr = 16L + (long)txRecordListsize + (long)CryptoFeeBuilder.getStateProofSize(responseType);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(244L).setVpt(0L).setRbh(0L).setSbh(0L).setGas(0L).setTv(0L).setBpr(bpr).setSbpr(0L).build();
        return CryptoFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public static FeeData getCostCryptoAccountRecordsQueryFeeMatrices() {
        return CryptoFeeBuilder.getCostForQueryByIdOnly();
    }

    public static FeeData getCostCryptoAccountInfoQueryFeeMatrices() {
        return CryptoFeeBuilder.getCostForQueryByIdOnly();
    }

    private static int getAccountTransactionRecordSize(TransactionRecord transRecord) {
        int memoBytesSize = transRecord.getMemoBytes().size();
        int accountAmountSize = transRecord.hasTransferList() ? transRecord.getTransferList().getAccountAmountsCount() * 32 : 0;
        return 132 + memoBytesSize + accountAmountSize;
    }
}

