/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.config;

import com.hedera.hapi.node.base.ServicesConfigurationList;
import com.hedera.node.app.config.ConfigMetrics;
import com.hedera.node.app.config.ConfigProviderBase;
import com.hedera.node.app.config.ServicesConfigExtension;
import com.hedera.node.config.VersionedConfigImpl;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.sources.PropertyConfigSource;
import com.hedera.node.config.sources.SettingsConfigSource;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.ConfigurationExtension;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SystemEnvironmentConfigSource;
import com.swirlds.config.extensions.sources.SystemPropertiesConfigSource;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.Locked;

@Singleton
public class ConfigProviderImpl
extends ConfigProviderBase {
    private static final Logger logger = LogManager.getLogger(ConfigProviderImpl.class);
    private final AtomicReference<VersionedConfiguration> configuration;
    private final AutoClosableLock updateLock = Locks.createAutoLock();
    private final ConfigMetrics configMetrics;
    private final Map<String, String> overrideValues;

    public ConfigProviderImpl() {
        this(false, null, null);
    }

    public ConfigProviderImpl(boolean useGenesisSource) {
        this(useGenesisSource, null, null);
    }

    public ConfigProviderImpl(boolean useGenesisSource, @Nullable Metrics metrics) {
        this(useGenesisSource, metrics, null);
    }

    public ConfigProviderImpl(boolean useGenesisSource, @Nullable Metrics metrics, @Nullable Map<String, String> overrideValues) {
        ConfigurationBuilder builder = this.createConfigurationBuilder();
        this.addFileSources(builder, useGenesisSource);
        if (overrideValues != null) {
            overrideValues.forEach((arg_0, arg_1) -> ((ConfigurationBuilder)builder).withValue(arg_0, arg_1));
            this.overrideValues = Map.copyOf(overrideValues);
        } else {
            this.overrideValues = Map.of();
        }
        Configuration config = builder.build();
        this.configuration = new AtomicReference<VersionedConfigImpl>(new VersionedConfigImpl(config, 0L));
        if (metrics != null) {
            this.configMetrics = new ConfigMetrics(metrics);
            this.configMetrics.reportMetrics(config);
        } else {
            this.configMetrics = null;
        }
    }

    @NonNull
    public VersionedConfiguration getConfiguration() {
        return this.configuration.get();
    }

    public void update(@NonNull Bytes networkProperties, @NonNull Bytes permissions) {
        logger.info("Updating configuration caused by properties or permissions override.");
        try (Locked ignoredLock = this.updateLock.lock();){
            ConfigurationBuilder builder = this.createConfigurationBuilder();
            this.addFileSources(builder, false);
            this.addByteSource(builder, networkProperties);
            this.addByteSource(builder, permissions);
            this.overrideValues.forEach((arg_0, arg_1) -> ((ConfigurationBuilder)builder).withValue(arg_0, arg_1));
            Configuration config = builder.build();
            this.configuration.set((VersionedConfiguration)new VersionedConfigImpl(config, this.configuration.get().getVersion() + 1L));
            if (this.configMetrics != null) {
                this.configMetrics.reportMetrics(config);
            }
        }
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = ConfigurationBuilder.create();
        builder.loadExtension((ConfigurationExtension)new ServicesConfigExtension()).withSource((ConfigSource)SystemEnvironmentConfigSource.getInstance()).withSource((ConfigSource)SystemPropertiesConfigSource.getInstance()).withSource((ConfigSource)new PropertyConfigSource("semantic-version.properties", 500));
        return builder;
    }

    private void addByteSource(@NonNull ConfigurationBuilder builder, @NonNull Bytes propertyFileContent) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(propertyFileContent);
        try {
            ServicesConfigurationList configurationList = (ServicesConfigurationList)ServicesConfigurationList.PROTOBUF.parseStrict(propertyFileContent.toReadableSequentialData());
            SettingsConfigSource configSource = new SettingsConfigSource(configurationList.nameValue(), 101);
            builder.withSource((ConfigSource)configSource);
        }
        catch (ParseException | NullPointerException throwable) {
            // empty catch block
        }
    }

    private void addFileSources(@NonNull ConfigurationBuilder builder, boolean useGenesisSource) {
        Objects.requireNonNull(builder);
        if (useGenesisSource) {
            try {
                this.addFileSource(builder, "HEDERA_GENESIS_PROPERTIES_PATH", "data/config/genesis.properties", 400);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not create config source for genesis properties", e);
            }
        }
        try {
            this.addFileSource(builder, "HEDERA_APP_PROPERTIES_PATH", "data/config/application.properties", 100);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create config source for application properties", e);
        }
    }
}

