/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.steps;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ServicesConfigurationList;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.config.ConfigProviderImpl;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.throttle.ThrottleServiceManager;
import com.hedera.node.app.util.FileUtilities;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class SystemFileUpdates {
    private static final Logger logger = LogManager.getLogger(SystemFileUpdates.class);
    private final ConfigProviderImpl configProvider;
    private final ExchangeRateManager exchangeRateManager;
    private final FeeManager feeManager;
    private final ThrottleServiceManager throttleServiceManager;

    @Inject
    public SystemFileUpdates(@NonNull ConfigProviderImpl configProvider, @NonNull ExchangeRateManager exchangeRateManager, @NonNull FeeManager feeManager, @NonNull ThrottleServiceManager throttleServiceManager) {
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager, "exchangeRateManager must not be null");
        this.feeManager = Objects.requireNonNull(feeManager, "feeManager must not be null");
        this.throttleServiceManager = Objects.requireNonNull(throttleServiceManager);
    }

    public ResponseCodeEnum handleTxBody(@NonNull State state, @NonNull TransactionBody txBody) {
        FileID fileID;
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(txBody, "txBody must not be null");
        if (txBody.hasFileUpdate()) {
            fileID = txBody.fileUpdateOrThrow().fileIDOrThrow();
        } else if (txBody.hasFileAppend()) {
            fileID = txBody.fileAppendOrThrow().fileIDOrThrow();
        } else {
            return ResponseCodeEnum.SUCCESS;
        }
        VersionedConfiguration configuration = this.configProvider.getConfiguration();
        LedgerConfig ledgerConfig = (LedgerConfig)configuration.getConfigData(LedgerConfig.class);
        long fileNum = fileID.fileNum();
        AccountID payer = txBody.transactionIDOrThrow().accountIDOrThrow();
        if (fileNum > ledgerConfig.numReservedSystemEntities()) {
            return ResponseCodeEnum.SUCCESS;
        }
        FilesConfig filesConfig = (FilesConfig)configuration.getConfigData(FilesConfig.class);
        if (fileNum == filesConfig.feeSchedules()) {
            return this.feeManager.update(FileUtilities.getFileContent(state, fileID));
        }
        if (fileNum == filesConfig.exchangeRates()) {
            this.exchangeRateManager.update(FileUtilities.getFileContent(state, fileID), payer);
        } else if (fileNum == filesConfig.networkProperties()) {
            this.updateConfig((Configuration)configuration, ConfigType.NETWORK_PROPERTIES, state);
            this.throttleServiceManager.refreshThrottleConfiguration();
        } else if (fileNum == filesConfig.hapiPermissions()) {
            this.updateConfig((Configuration)configuration, ConfigType.API_PERMISSIONS, state);
        } else if (fileNum == filesConfig.throttleDefinitions()) {
            return this.throttleServiceManager.recreateThrottles(FileUtilities.getFileContent(state, fileID));
        }
        return ResponseCodeEnum.SUCCESS;
    }

    private void updateConfig(@NonNull Configuration configuration, @NonNull ConfigType configType, @NonNull State state) {
        FileUtilities.observePropertiesAndPermissions(state, configuration, (properties, permissions) -> {
            this.configProvider.update(properties, permissions);
            if (configType == ConfigType.NETWORK_PROPERTIES) {
                this.logContentsOf("Network properties", properties);
            } else {
                this.logContentsOf("API permissions", permissions);
            }
        });
    }

    private void logContentsOf(@NonNull String configFileName, @NonNull Bytes contents) {
        try {
            ServicesConfigurationList configList = (ServicesConfigurationList)ServicesConfigurationList.PROTOBUF.parseStrict(contents.toReadableSequentialData());
            String printableConfigList = configList.nameValue().stream().map(pair -> pair.name() + "=" + pair.value()).collect(Collectors.joining("\n\t"));
            logger.info("Refreshing properties with following overrides to {}:\n\t{}", (Object)configFileName, (Object)(printableConfigList.isBlank() ? "<NONE>" : printableConfigList));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private static enum ConfigType {
        NETWORK_PROPERTIES,
        API_PERMISSIONS;

    }
}

