/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.pricing;

import com.hedera.node.app.hapi.fees.pricing.AssetsLoader;
import com.hedera.node.app.hapi.fees.pricing.BaseOperationUsage;
import com.hedera.node.app.hapi.fees.pricing.ResourceProvider;
import com.hedera.node.app.hapi.fees.pricing.UsableResource;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.SubType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.EnumMap;
import java.util.Map;

public class FeeSchedules {
    public static final BigDecimal USD_TO_TINYCENTS = BigDecimal.valueOf(10000000000L);
    static final BigDecimal FEE_SCHEDULE_MULTIPLIER = BigDecimal.valueOf(1000L);
    private static final AssetsLoader ASSETS_LOADER = new AssetsLoader();
    private static final BaseOperationUsage CANONICAL_OPS = new BaseOperationUsage();

    Map<ResourceProvider, Map<UsableResource, Long>> canonicalPricesFor(HederaFunctionality function, SubType type) throws IOException {
        UsageAccumulator canonicalUsage = CANONICAL_OPS.baseUsageFor(function, type);
        Map<ResourceProvider, Map<UsableResource, BigDecimal>> genericPrices = this.genericPricesFor(function);
        BigDecimal genericPrice = this.computeGenericGiven(canonicalUsage, genericPrices);
        BigDecimal canonicalPrice = ASSETS_LOADER.loadCanonicalPrices().get(function).get(type);
        BigDecimal normalizingFactor = FEE_SCHEDULE_MULTIPLIER.multiply(canonicalPrice).divide(genericPrice, MathContext.DECIMAL128).multiply(USD_TO_TINYCENTS);
        return this.canonicalPricesGiven(normalizingFactor, genericPrices);
    }

    private Map<ResourceProvider, Map<UsableResource, Long>> canonicalPricesGiven(BigDecimal normalizingFactor, Map<ResourceProvider, Map<UsableResource, BigDecimal>> genericPrices) {
        EnumMap<ResourceProvider, Map<UsableResource, Long>> canonicalPrices = new EnumMap<ResourceProvider, Map<UsableResource, Long>>(ResourceProvider.class);
        for (ResourceProvider provider : (ResourceProvider[])ResourceProvider.class.getEnumConstants()) {
            EnumMap<UsableResource, Long> providerPrices = new EnumMap<UsableResource, Long>(UsableResource.class);
            Map<UsableResource, BigDecimal> providerGenerics = genericPrices.get((Object)provider);
            for (UsableResource resource : (UsableResource[])UsableResource.class.getEnumConstants()) {
                BigDecimal genericPrice = providerGenerics.get((Object)resource);
                BigDecimal exactCanonicalPrice = normalizingFactor.multiply(genericPrice);
                long canonicalPrice = exactCanonicalPrice.setScale(0, RoundingMode.HALF_UP).longValueExact();
                providerPrices.put(resource, canonicalPrice);
            }
            canonicalPrices.put(provider, providerPrices);
        }
        return canonicalPrices;
    }

    private BigDecimal computeGenericGiven(UsageAccumulator canonicalUsage, Map<ResourceProvider, Map<UsableResource, BigDecimal>> genericPrices) {
        BigDecimal sum = BigDecimal.ZERO;
        for (ResourceProvider provider : (ResourceProvider[])ResourceProvider.class.getEnumConstants()) {
            Map<UsableResource, BigDecimal> providerGenerics = genericPrices.get((Object)provider);
            for (UsableResource resource : (UsableResource[])UsableResource.class.getEnumConstants()) {
                BigDecimal bdUsage = BigDecimal.valueOf(canonicalUsage.get(provider, resource));
                sum = sum.add(providerGenerics.get((Object)resource).multiply(bdUsage));
            }
        }
        return sum;
    }

    private Map<ResourceProvider, Map<UsableResource, BigDecimal>> genericPricesFor(HederaFunctionality function) throws IOException {
        Map<UsableResource, BigDecimal> capacities = ASSETS_LOADER.loadCapacities();
        BigDecimal constW = ASSETS_LOADER.loadConstWeights().get(function);
        BigDecimal oneMinusConstW = BigDecimal.ONE.subtract(constW);
        EnumMap<ResourceProvider, Map<UsableResource, BigDecimal>> generics = new EnumMap<ResourceProvider, Map<UsableResource, BigDecimal>>(ResourceProvider.class);
        for (ResourceProvider provider : (ResourceProvider[])ResourceProvider.class.getEnumConstants()) {
            EnumMap<UsableResource, BigDecimal> providerGenerics = new EnumMap<UsableResource, BigDecimal>(UsableResource.class);
            BigDecimal nonConstantGenerics = BigDecimal.ZERO;
            for (UsableResource resource : (UsableResource[])UsableResource.class.getEnumConstants()) {
                BigDecimal scale = BigDecimal.valueOf(provider.relativeWeight());
                BigDecimal capacity = capacities.get((Object)resource);
                BigDecimal generic = BigDecimal.ONE.divide(capacity, MathContext.DECIMAL128).multiply(scale);
                providerGenerics.put(resource, generic);
                if (resource == UsableResource.CONSTANT) continue;
                nonConstantGenerics = nonConstantGenerics.add(generic);
            }
            providerGenerics.put(UsableResource.CONSTANT, nonConstantGenerics.multiply(constW).divide(oneMinusConstW, MathContext.DECIMAL128));
            generics.put(provider, providerGenerics);
        }
        return generics;
    }
}

