/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.operation.Operation;

public class OperationRegistry {
    private static final int NUM_OPERATIONS = 256;
    private final Operation[] operations = new Operation[256];

    public Operation get(byte opcode) {
        return this.get(opcode & 0xFF);
    }

    public Operation get(int opcode) {
        return this.operations[opcode];
    }

    public void put(Operation operation) {
        this.operations[operation.getOpcode()] = operation;
    }

    public Operation getOrDefault(byte opcode, Operation defaultOperation) {
        Operation operation = this.get(opcode);
        if (operation == null) {
            return defaultOperation;
        }
        return operation;
    }

    public Operation[] getOperations() {
        return this.operations;
    }
}

