/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SPIOperation;

public final class SchemaBuilder {
    private final Class<? extends Connector> _connectorClass;
    private final Set<ObjectClassInfo> _declaredObjectClasses = new HashSet<ObjectClassInfo>();
    private final Set<OperationOptionInfo> _declaredOperationOptions = new HashSet<OperationOptionInfo>();
    private final Map<Class<? extends APIOperation>, Set<ObjectClassInfo>> _supportedObjectClassesByOperation = new HashMap<Class<? extends APIOperation>, Set<ObjectClassInfo>>();
    private final Map<Class<? extends APIOperation>, Set<OperationOptionInfo>> _supportedOptionsByOperation = new HashMap<Class<? extends APIOperation>, Set<OperationOptionInfo>>();

    public SchemaBuilder(Class<? extends Connector> connectorClass) {
        Assertions.nullCheck(connectorClass, "connectorClass");
        this._connectorClass = connectorClass;
    }

    public void defineObjectClass(ObjectClassInfo info) {
        Assertions.nullCheck(info, "info");
        if (this._declaredObjectClasses.contains(info)) {
            throw new IllegalStateException("ObjectClass already defined: " + info.getType());
        }
        this._declaredObjectClasses.add(info);
        for (Class<? extends APIOperation> op : FrameworkUtil.getDefaultSupportedOperations(this._connectorClass)) {
            Set<ObjectClassInfo> oclasses = this._supportedObjectClassesByOperation.get(op);
            if (oclasses == null) {
                oclasses = new HashSet<ObjectClassInfo>();
                this._supportedObjectClassesByOperation.put(op, oclasses);
            }
            oclasses.add(info);
        }
    }

    public void defineOperationOption(OperationOptionInfo info) {
        Assertions.nullCheck(info, "info");
        if (this._declaredOperationOptions.contains(info)) {
            throw new IllegalStateException("OperationOption already defined: " + info.getName());
        }
        this._declaredOperationOptions.add(info);
        for (Class<? extends APIOperation> op : FrameworkUtil.getDefaultSupportedOperations(this._connectorClass)) {
            Set<OperationOptionInfo> oclasses = this._supportedOptionsByOperation.get(op);
            if (oclasses == null) {
                oclasses = new HashSet<OperationOptionInfo>();
                this._supportedOptionsByOperation.put(op, oclasses);
            }
            oclasses.add(info);
        }
    }

    public void defineObjectClass(String type, Set<AttributeInfo> attrInfo) {
        ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
        bld.setType(type);
        bld.addAllAttributeInfo(attrInfo);
        ObjectClassInfo obj = bld.build();
        this.defineObjectClass(obj);
    }

    public void defineOperationOption(String optionName, Class<?> type) {
        OperationOptionInfoBuilder bld = new OperationOptionInfoBuilder();
        bld.setName(optionName);
        bld.setType(type);
        OperationOptionInfo info = bld.build();
        this.defineOperationOption(info);
    }

    public void addSupportedObjectClass(Class<? extends SPIOperation> op, ObjectClassInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        if (!this._declaredObjectClasses.contains(def)) {
            throw new IllegalArgumentException("ObjectClass " + def.getType() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            Set<ObjectClassInfo> infos = this._supportedObjectClassesByOperation.get(api);
            if (infos == null) {
                throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
            }
            if (infos.contains(def)) {
                throw new IllegalArgumentException("ObjectClass " + def.getType() + " already supported for operation " + op.getName());
            }
            infos.add(def);
        }
    }

    public void removeSupportedObjectClass(Class<? extends SPIOperation> op, ObjectClassInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        if (!this._declaredObjectClasses.contains(def)) {
            throw new IllegalArgumentException("ObjectClass " + def.getType() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            Set<ObjectClassInfo> infos = this._supportedObjectClassesByOperation.get(api);
            if (infos == null) {
                throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
            }
            if (!infos.contains(def)) {
                throw new IllegalArgumentException("ObjectClass " + def.getType() + " already removed for operation " + op.getName());
            }
            infos.remove(def);
        }
    }

    public void addSupportedOperationOption(Class<? extends SPIOperation> op, OperationOptionInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        if (!this._declaredOperationOptions.contains(def)) {
            throw new IllegalArgumentException("OperationOption " + def.getName() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            Set<OperationOptionInfo> infos = this._supportedOptionsByOperation.get(api);
            if (infos == null) {
                throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
            }
            if (infos.contains(def)) {
                throw new IllegalArgumentException("OperationOption " + def.getName() + " already supported for operation " + op.getName());
            }
            infos.add(def);
        }
    }

    public void removeSupportedOperationOption(Class<? extends SPIOperation> op, OperationOptionInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        if (!this._declaredOperationOptions.contains(def)) {
            throw new IllegalArgumentException("OperationOption " + def.getName() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            Set<OperationOptionInfo> infos = this._supportedOptionsByOperation.get(api);
            if (infos == null) {
                throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
            }
            if (!infos.contains(def)) {
                throw new IllegalArgumentException("OperationOption " + def.getName() + " already removed for operation " + op.getName());
            }
            infos.remove(def);
        }
    }

    public void clearSupportedObjectClassesByOperation() {
        for (Set<ObjectClassInfo> values : this._supportedObjectClassesByOperation.values()) {
            values.clear();
        }
    }

    public void clearSupportedOptionsByOperation() {
        for (Set<OperationOptionInfo> values : this._supportedOptionsByOperation.values()) {
            values.clear();
        }
    }

    public Schema build() {
        if (this._declaredObjectClasses.isEmpty()) {
            String ERR = "Must be at least one ObjectClassInfo object!";
            throw new IllegalStateException("Must be at least one ObjectClassInfo object!");
        }
        return new Schema(this._declaredObjectClasses, this._declaredOperationOptions, this._supportedObjectClassesByOperation, this._supportedOptionsByOperation);
    }
}

