/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.collections.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hyperledger.besu.collections.undo.Undoable;

public class UndoSet<V>
implements Set<V>,
Undoable {
    Set<V> delegate;
    List<UndoEntry<V>> undoLog;

    public static <V> UndoSet<V> of(Set<V> delegate) {
        return new UndoSet<V>(delegate);
    }

    UndoSet(Set<V> delegate) {
        this.delegate = delegate;
        this.undoLog = new ArrayList<UndoEntry<V>>();
    }

    @Override
    public void undo(long mark) {
        for (int pos = this.undoLog.size() - 1; pos >= 0 && this.undoLog.get((int)pos).level > mark; --pos) {
            UndoEntry<V> entry = this.undoLog.get(pos);
            if (entry.add) {
                this.delegate.remove(entry.value());
            } else {
                this.delegate.add(entry.value());
            }
            this.undoLog.remove(pos);
        }
    }

    @Override
    public long lastUpdate() {
        return this.undoLog.isEmpty() ? 0L : this.undoLog.get((int)(this.undoLog.size() - 1)).level;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object key) {
        return this.delegate.contains(key);
    }

    @Override
    public boolean add(V key) {
        boolean added = this.delegate.add(key);
        if (added) {
            this.undoLog.add(UndoEntry.add(key));
        }
        return added;
    }

    @Override
    public boolean remove(Object key) {
        boolean removed = this.delegate.remove(key);
        if (removed) {
            this.undoLog.add(UndoEntry.remove(key));
        }
        return removed;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends V> m) {
        boolean added = false;
        for (V v : m) {
            added &= this.add(v);
        }
        return added;
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        boolean removed = false;
        for (Object v : c) {
            removed &= this.remove(v);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        boolean removed = false;
        HashSet hashed = new HashSet(c);
        Iterator<V> iter = this.delegate.iterator();
        while (iter.hasNext()) {
            V v = iter.next();
            if (hashed.contains(v)) continue;
            removed = true;
            this.undoLog.add(UndoEntry.remove(v));
            iter.remove();
        }
        return removed;
    }

    @Override
    public void clear() {
        this.delegate.forEach(v -> this.undoLog.add(UndoEntry.remove(v)));
        this.delegate.clear();
    }

    @Override
    @Nonnull
    public Iterator<V> iterator() {
        return new Undoable.ReadOnlyIterator<V>(this.delegate.iterator());
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof UndoSet && this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode() ^ 0xDE1E647E;
    }

    record UndoEntry<V>(V value, boolean add, long level) {
        static <V> UndoEntry<V> add(V value) {
            return new UndoEntry<V>(value, true, Undoable.incrementMarkStatic());
        }

        static <V> UndoEntry<V> remove(V value) {
            return new UndoEntry<V>(value, false, Undoable.incrementMarkStatic());
        }
    }
}

