/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.frame;

public interface ExceptionalHaltReason {
    public static final ExceptionalHaltReason NONE = DefaultExceptionalHaltReason.NONE;
    public static final ExceptionalHaltReason INSUFFICIENT_GAS = DefaultExceptionalHaltReason.INSUFFICIENT_GAS;
    public static final ExceptionalHaltReason INSUFFICIENT_STACK_ITEMS = DefaultExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS;
    public static final ExceptionalHaltReason INVALID_JUMP_DESTINATION = DefaultExceptionalHaltReason.INVALID_JUMP_DESTINATION;
    public static final ExceptionalHaltReason INVALID_OPERATION = DefaultExceptionalHaltReason.INVALID_OPERATION;
    public static final ExceptionalHaltReason INVALID_RETURN_DATA_BUFFER_ACCESS = DefaultExceptionalHaltReason.INVALID_RETURN_DATA_BUFFER_ACCESS;
    public static final ExceptionalHaltReason TOO_MANY_STACK_ITEMS = DefaultExceptionalHaltReason.TOO_MANY_STACK_ITEMS;
    public static final ExceptionalHaltReason ILLEGAL_STATE_CHANGE = DefaultExceptionalHaltReason.ILLEGAL_STATE_CHANGE;
    public static final ExceptionalHaltReason OUT_OF_BOUNDS = DefaultExceptionalHaltReason.OUT_OF_BOUNDS;
    public static final ExceptionalHaltReason CODE_TOO_LARGE = DefaultExceptionalHaltReason.CODE_TOO_LARGE;
    public static final ExceptionalHaltReason INVALID_CODE = DefaultExceptionalHaltReason.INVALID_CODE;
    public static final ExceptionalHaltReason PRECOMPILE_ERROR = DefaultExceptionalHaltReason.PRECOMPILE_ERROR;
    public static final ExceptionalHaltReason CODE_SECTION_MISSING = DefaultExceptionalHaltReason.CODE_SECTION_MISSING;
    public static final ExceptionalHaltReason INCORRECT_CODE_SECTION_RETURN_OUTPUTS = DefaultExceptionalHaltReason.INCORRECT_CODE_SECTION_RETURN_OUTPUTS;
    public static final ExceptionalHaltReason TOO_FEW_INPUTS_FOR_CODE_SECTION = DefaultExceptionalHaltReason.TOO_FEW_INPUTS_FOR_CODE_SECTION;
    public static final ExceptionalHaltReason JUMPF_STACK_MISMATCH = DefaultExceptionalHaltReason.JUMPF_STACK_MISMATCH;
    public static final ExceptionalHaltReason EOF_CREATE_VERSION_INCOMPATIBLE = DefaultExceptionalHaltReason.EOF_CREATE_VERSION_INCOMPATIBLE;

    public String name();

    public String getDescription();

    public static enum DefaultExceptionalHaltReason implements ExceptionalHaltReason
    {
        NONE(""),
        INSUFFICIENT_GAS("Out of gas"),
        INSUFFICIENT_STACK_ITEMS("Stack underflow"),
        INVALID_JUMP_DESTINATION("Bad jump destination"),
        INVALID_OPERATION("Bad instruction"),
        INVALID_RETURN_DATA_BUFFER_ACCESS("Out of bounds"),
        TOO_MANY_STACK_ITEMS("Out of stack"),
        ILLEGAL_STATE_CHANGE("Illegal state change"),
        OUT_OF_BOUNDS("Out of bounds"),
        CODE_TOO_LARGE("Code is too large"),
        INVALID_CODE("Code is invalid"),
        PRECOMPILE_ERROR("Precompile error"),
        CODE_SECTION_MISSING("No code section at requested index"),
        INSUFFICIENT_CODE_SECTION_RETURN_DATA("The stack for a return "),
        INCORRECT_CODE_SECTION_RETURN_OUTPUTS("The return of a code section does not have the correct number of outputs"),
        TOO_FEW_INPUTS_FOR_CODE_SECTION("Not enough stack items for a function call"),
        JUMPF_STACK_MISMATCH("The stack height for a JUMPF does not match the requirements of the target section"),
        EOF_CREATE_VERSION_INCOMPATIBLE("EOF Code is attempting to create EOF code of an earlier version");

        final String description;

        private DefaultExceptionalHaltReason(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

