/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CallFOperation
extends AbstractOperation {
    public static final int OPCODE = 227;
    static final Operation.OperationResult callfSuccess = new Operation.OperationResult(5L, null);

    public CallFOperation(GasCalculator gasCalculator) {
        super(227, "CALLF", 0, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        byte[] code = frame.getCode().getBytes().toArrayUnsafe();
        return CallFOperation.staticOperation(frame, code, frame.getPC());
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame, byte[] code, int pc) {
        int section = Words.readBigEndianU16(pc + 1, code);
        ExceptionalHaltReason exception = frame.callFunction(section);
        if (exception == null) {
            return callfSuccess;
        }
        return new Operation.OperationResult(CallFOperation.callfSuccess.gasCost, exception);
    }
}

