/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.hedera.hapi.node.state.hints.PreprocessedKeys;
import com.hedera.hapi.node.state.hints.PreprocessingVote;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.hapi.services.auxiliary.hints.HintsKeyPublicationTransactionBody;
import com.hedera.hapi.services.auxiliary.hints.HintsPartialSignatureTransactionBody;
import com.hedera.hapi.services.auxiliary.hints.HintsPreprocessingVoteTransactionBody;
import com.hedera.node.app.hints.impl.HintsContext;
import com.hedera.node.app.hints.impl.HintsKeyAccessor;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.tss.TssSubmissions;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class HintsSubmissions
extends TssSubmissions {
    private static final Logger logger = LogManager.getLogger(HintsSubmissions.class);
    private final HintsContext context;
    private final HintsKeyAccessor keyAccessor;
    private final BiConsumer<TransactionBody, String> onFailure = (body, reason) -> logger.warn("Failed to submit {} ({})", body, reason);

    @Inject
    public HintsSubmissions(@NonNull Executor executor, @NonNull AppContext appContext, @NonNull HintsKeyAccessor keyAccessor, @NonNull HintsContext context) {
        super(executor, appContext);
        this.keyAccessor = Objects.requireNonNull(keyAccessor);
        this.context = Objects.requireNonNull(context);
    }

    public CompletableFuture<Void> submitHintsKey(int partyId, int numParties, @NonNull Bytes hintsKey) {
        Objects.requireNonNull(hintsKey);
        HintsKeyPublicationTransactionBody op = new HintsKeyPublicationTransactionBody(partyId, numParties, hintsKey);
        return this.submitIfActive(b -> b.hintsKeyPublication(op), this.onFailure);
    }

    public CompletableFuture<Void> submitCrsUpdate(@NonNull Bytes crs, @NonNull Bytes proof) {
        Objects.requireNonNull(crs);
        CrsPublicationTransactionBody op = CrsPublicationTransactionBody.newBuilder().newCrs(crs).proof(proof).build();
        return this.submitIfActive(b -> b.crsPublication(op), this.onFailure);
    }

    public CompletableFuture<Void> submitHintsVote(long constructionId, long congruentNodeId) {
        HintsPreprocessingVoteTransactionBody op = HintsPreprocessingVoteTransactionBody.newBuilder().constructionId(constructionId).vote(PreprocessingVote.newBuilder().congruentNodeId(congruentNodeId).build()).build();
        return this.submitIfActive(b -> b.hintsPreprocessingVote(op), this.onFailure);
    }

    public CompletableFuture<Void> submitHintsVote(long constructionId, @NonNull PreprocessedKeys preprocessedKeys) {
        HintsPreprocessingVoteTransactionBody op = HintsPreprocessingVoteTransactionBody.newBuilder().constructionId(constructionId).vote(PreprocessingVote.newBuilder().preprocessedKeys(preprocessedKeys).build()).build();
        return this.submitIfActive(b -> b.hintsPreprocessingVote(op), this.onFailure);
    }

    public CompletableFuture<Void> submitPartialSignature(@NonNull Bytes message) {
        Objects.requireNonNull(message);
        long constructionId = this.context.constructionIdOrThrow();
        return this.submitIfActive(b -> {
            Bytes signature = this.keyAccessor.signWithBlsPrivateKey(constructionId, message);
            b.hintsPartialSignature(new HintsPartialSignatureTransactionBody(constructionId, message, Objects.requireNonNull(signature)));
        }, this.onFailure);
    }
}

