/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.hints.CRSState;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.hints.HintsKeySet;
import com.hedera.hapi.node.state.hints.HintsPartyId;
import com.hedera.hapi.node.state.hints.PreprocessingVote;
import com.hedera.hapi.node.state.hints.PreprocessingVoteId;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.hints.ReadableHintsStore;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReadableHintsStoreImpl
implements ReadableHintsStore {
    private final ReadableKVState<HintsPartyId, HintsKeySet> hintsKeys;
    private final ReadableSingletonState<HintsConstruction> nextConstruction;
    private final ReadableSingletonState<HintsConstruction> activeConstruction;
    private final ReadableKVState<PreprocessingVoteId, PreprocessingVote> votes;
    private final ReadableSingletonState<CRSState> crs;
    private final ReadableKVState<NodeId, CrsPublicationTransactionBody> crsPublications;
    private final ReadableEntityCounters entityCounters;

    public ReadableHintsStoreImpl(@NonNull ReadableStates states, ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states);
        this.hintsKeys = states.get("HINTS_KEY_SETS");
        this.nextConstruction = states.getSingleton("NEXT_HINT_CONSTRUCTION");
        this.activeConstruction = states.getSingleton("ACTIVE_HINT_CONSTRUCTION");
        this.votes = states.get("PREPROCESSING_VOTES");
        this.crs = states.getSingleton("CRS_STATE");
        this.crsPublications = states.get("CRS_PUBLICATIONS");
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    @Override
    @Nullable
    public Bytes getActiveVerificationKey() {
        HintsConstruction construction = Objects.requireNonNull((HintsConstruction)this.activeConstruction.get());
        if (construction.hasHintsScheme()) {
            return construction.hintsSchemeOrThrow().preprocessedKeysOrThrow().verificationKey();
        }
        return null;
    }

    @Override
    @NonNull
    public HintsConstruction getActiveConstruction() {
        return Objects.requireNonNull((HintsConstruction)this.activeConstruction.get());
    }

    @Override
    @NonNull
    public HintsConstruction getNextConstruction() {
        return Objects.requireNonNull((HintsConstruction)this.nextConstruction.get());
    }

    @Override
    @Nullable
    public HintsConstruction getConstructionFor(@NonNull ActiveRosters activeRosters) {
        Objects.requireNonNull(activeRosters);
        return switch (activeRosters.phase()) {
            default -> throw new MatchException(null, null);
            case ActiveRosters.Phase.BOOTSTRAP, ActiveRosters.Phase.TRANSITION -> {
                HintsConstruction construction = Objects.requireNonNull((HintsConstruction)this.activeConstruction.get());
                if (this.constructionIsFor(construction, activeRosters)) {
                    yield construction;
                }
                construction = Objects.requireNonNull((HintsConstruction)this.nextConstruction.get());
                if (this.constructionIsFor(construction, activeRosters)) {
                    yield construction;
                }
                yield null;
            }
            case ActiveRosters.Phase.HANDOFF -> null;
        };
    }

    @Override
    @NonNull
    public Map<Long, PreprocessingVote> getVotes(long constructionId, @NonNull Set<Long> nodeIds) {
        Objects.requireNonNull(nodeIds);
        HashMap<Long, PreprocessingVote> constructionVotes = new HashMap<Long, PreprocessingVote>();
        for (Long nodeId : nodeIds) {
            PreprocessingVote vote = (PreprocessingVote)this.votes.get((Object)new PreprocessingVoteId(constructionId, nodeId.longValue()));
            if (vote == null) continue;
            constructionVotes.put(nodeId, vote);
        }
        return constructionVotes;
    }

    @Override
    @NonNull
    public List<ReadableHintsStore.HintsKeyPublication> getHintsKeyPublications(@NonNull Set<Long> nodeIds, int numParties) {
        Objects.requireNonNull(nodeIds);
        ArrayList<ReadableHintsStore.HintsKeyPublication> publications = new ArrayList<ReadableHintsStore.HintsKeyPublication>();
        for (int partyId = 0; partyId < numParties; ++partyId) {
            HintsKeySet keySet = (HintsKeySet)this.hintsKeys.get((Object)new HintsPartyId(partyId, numParties));
            if (keySet == null || !nodeIds.contains(keySet.nodeId())) continue;
            publications.add(new ReadableHintsStore.HintsKeyPublication(keySet.nodeId(), keySet.key(), partyId, HapiUtils.asInstant((Timestamp)keySet.adoptionTimeOrThrow())));
        }
        return publications;
    }

    @Override
    @NonNull
    public CRSState getCrsState() {
        return Objects.requireNonNull((CRSState)this.crs.get());
    }

    @Override
    public List<CrsPublicationTransactionBody> getCrsPublications() {
        long nodesSize = this.entityCounters.getCounterFor(EntityType.NODE);
        ArrayList<CrsPublicationTransactionBody> publications = new ArrayList<CrsPublicationTransactionBody>();
        int i = 0;
        while ((long)i < nodesSize) {
            NodeId nodeId = new NodeId((long)i);
            CrsPublicationTransactionBody publication = (CrsPublicationTransactionBody)this.crsPublications.get((Object)nodeId);
            if (publication != null) {
                publications.add(publication);
            }
            ++i;
        }
        return publications;
    }

    @Override
    public Map<Long, CrsPublicationTransactionBody> getOrderedCrsPublications(@NonNull Set<Long> nodeIds) {
        HashMap<Long, CrsPublicationTransactionBody> publications = new HashMap<Long, CrsPublicationTransactionBody>();
        for (Long nodeId : nodeIds) {
            CrsPublicationTransactionBody publication = (CrsPublicationTransactionBody)this.crsPublications.get((Object)new NodeId(nodeId.longValue()));
            if (publication == null) continue;
            publications.put(nodeId, publication);
        }
        return publications;
    }

    private boolean constructionIsFor(@NonNull HintsConstruction construction, @NonNull ActiveRosters activeRosters) {
        return activeRosters.sourceRosterHash().equals((Object)construction.sourceRosterHash()) && activeRosters.targetRosterHash().equals((Object)construction.targetRosterHash());
    }
}

