/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.ConstructionNodeId;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKeySet;
import com.hedera.hapi.node.state.history.RecordedHistorySignature;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.ReadableHistoryStoreImpl;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.RosterUtils;

public class WritableHistoryStoreImpl
extends ReadableHistoryStoreImpl
implements WritableHistoryStore {
    private static final Logger logger = LogManager.getLogger(WritableHistoryStoreImpl.class);
    private final WritableSingletonState<ProtoBytes> ledgerId;
    private final WritableSingletonState<HistoryProofConstruction> nextConstruction;
    private final WritableSingletonState<HistoryProofConstruction> activeConstruction;
    private final WritableKVState<NodeId, ProofKeySet> proofKeySets;
    private final WritableKVState<ConstructionNodeId, RecordedHistorySignature> signatures;
    private final WritableKVState<ConstructionNodeId, HistoryProofVote> votes;

    public WritableHistoryStoreImpl(@NonNull WritableStates states) {
        super((ReadableStates)states);
        this.ledgerId = states.getSingleton("LEDGER_ID");
        this.nextConstruction = states.getSingleton("NEXT_PROOF_CONSTRUCTION");
        this.activeConstruction = states.getSingleton("ACTIVE_PROOF_CONSTRUCTION");
        this.proofKeySets = states.get("PROOF_KEY_SETS");
        this.signatures = states.get("HISTORY_SIGNATURES");
        this.votes = states.get("PROOF_VOTES");
    }

    @Override
    @NonNull
    public HistoryProofConstruction getOrCreateConstruction(@NonNull ActiveRosters activeRosters, @NonNull Instant now, @NonNull TssConfig tssConfig) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(now);
        Objects.requireNonNull(tssConfig);
        ActiveRosters.Phase phase = activeRosters.phase();
        if (phase == ActiveRosters.Phase.HANDOFF) {
            throw new IllegalArgumentException("Handoff phase has no construction");
        }
        HistoryProofConstruction construction = this.getConstructionFor(activeRosters);
        if (construction == null) {
            Duration gracePeriod = phase == ActiveRosters.Phase.BOOTSTRAP ? tssConfig.bootstrapProofKeyGracePeriod() : tssConfig.transitionProofKeyGracePeriod();
            construction = this.updateForNewConstruction(activeRosters.sourceRosterHash(), activeRosters.targetRosterHash(), activeRosters::findRelatedRoster, now, gracePeriod);
        }
        return construction;
    }

    @Override
    public boolean setProofKey(long nodeId, @NonNull Bytes proofKey, @NonNull Instant now) {
        Objects.requireNonNull(proofKey);
        Objects.requireNonNull(now);
        NodeId id = new NodeId(nodeId);
        ProofKeySet keySet = (ProofKeySet)this.proofKeySets.get((Object)id);
        boolean inUse = false;
        if (keySet == null) {
            inUse = true;
            keySet = ProofKeySet.newBuilder().key(proofKey).adoptionTime(HapiUtils.asTimestamp((Instant)now)).build();
        } else {
            keySet = keySet.copyBuilder().nextKey(proofKey).build();
        }
        this.proofKeySets.put((Object)id, (Object)keySet);
        return inUse;
    }

    @Override
    public HistoryProofConstruction setAssemblyTime(long constructionId, @NonNull Instant now) {
        Objects.requireNonNull(now);
        return this.updateOrThrow(constructionId, b -> b.assemblyStartTime(HapiUtils.asTimestamp((Instant)now)));
    }

    @Override
    public void addSignature(long constructionId, @NonNull ReadableHistoryStore.HistorySignaturePublication publication) {
        Objects.requireNonNull(publication);
        this.signatures.put((Object)new ConstructionNodeId(constructionId, publication.nodeId()), (Object)new RecordedHistorySignature(HapiUtils.asTimestamp((Instant)publication.at()), publication.signature()));
    }

    @Override
    public void addProofVote(long nodeId, long constructionId, @NonNull HistoryProofVote vote) {
        Objects.requireNonNull(vote);
        this.votes.put((Object)new ConstructionNodeId(constructionId, nodeId), (Object)vote);
    }

    @Override
    public HistoryProofConstruction completeProof(long constructionId, @NonNull HistoryProof proof) {
        Objects.requireNonNull(proof);
        return this.updateOrThrow(constructionId, b -> b.targetProof(proof));
    }

    @Override
    public HistoryProofConstruction failForReason(long constructionId, @NonNull String reason) {
        Objects.requireNonNull(reason);
        return this.updateOrThrow(constructionId, b -> b.failureReason(reason));
    }

    @Override
    public void setLedgerId(@NonNull Bytes bytes) {
        Objects.requireNonNull(bytes);
        this.ledgerId.put((Object)new ProtoBytes(bytes));
    }

    @Override
    public boolean handoff(@NonNull Roster fromRoster, @NonNull Roster toRoster, @NonNull Bytes toRosterHash) {
        if (Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).targetRosterHash().equals((Object)toRosterHash)) {
            HistoryProofConstruction upcomingConstruction = Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
            this.purgeVotesAndSignatures(upcomingConstruction.constructionId(), fromRoster);
            if (fromRoster != toRoster && !RosterUtils.isWeightRotation((Roster)fromRoster, (Roster)toRoster)) {
                Set survivingNodeIds = toRoster.rosterEntries().stream().map(RosterEntry::nodeId).collect(Collectors.toSet());
                fromRoster.rosterEntries().forEach(entry -> {
                    long nodeId = entry.nodeId();
                    if (!survivingNodeIds.contains(nodeId)) {
                        this.proofKeySets.remove((Object)new NodeId(nodeId));
                    }
                });
            }
            this.activeConstruction.put((Object)((HistoryProofConstruction)this.nextConstruction.get()));
            this.nextConstruction.put((Object)HistoryProofConstruction.DEFAULT);
            return true;
        }
        return false;
    }

    private HistoryProofConstruction updateOrThrow(long constructionId, @NonNull UnaryOperator<HistoryProofConstruction.Builder> spec) {
        HistoryProofConstruction construction = (HistoryProofConstruction)this.activeConstruction.get();
        if (Objects.requireNonNull(construction).constructionId() == constructionId) {
            construction = ((HistoryProofConstruction.Builder)spec.apply(construction.copyBuilder())).build();
            this.activeConstruction.put((Object)construction);
        } else {
            construction = (HistoryProofConstruction)this.nextConstruction.get();
            if (Objects.requireNonNull(construction).constructionId() == constructionId) {
                construction = ((HistoryProofConstruction.Builder)spec.apply(construction.copyBuilder())).build();
                this.nextConstruction.put((Object)construction);
            } else {
                throw new IllegalArgumentException("No construction with id " + constructionId);
            }
        }
        return construction;
    }

    private HistoryProofConstruction updateForNewConstruction(@NonNull Bytes sourceRosterHash, @NonNull Bytes targetRosterHash, @NonNull Function<Bytes, Roster> lookup, @NonNull Instant now, @NonNull Duration gracePeriod) {
        HistoryProofConstruction construction = HistoryProofConstruction.newBuilder().constructionId(this.newConstructionId()).sourceRosterHash(sourceRosterHash).targetRosterHash(targetRosterHash).gracePeriodEndTime(HapiUtils.asTimestamp((Instant)now.plus(gracePeriod))).build();
        HistoryProofConstruction activeChoice = Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
        if (activeChoice.equals((Object)HistoryProofConstruction.DEFAULT)) {
            this.activeConstruction.put((Object)construction);
            this.logNewConstruction(construction, InSlot.ACTIVE, sourceRosterHash, targetRosterHash);
        } else {
            if (!Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).equals((Object)HistoryProofConstruction.DEFAULT)) {
                HistoryProofConstruction extantConstruction = Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get());
                Roster sourceRoster = Objects.requireNonNull(lookup.apply(extantConstruction.sourceRosterHash()));
                this.purgeVotesAndSignatures(extantConstruction.constructionId(), sourceRoster);
            }
            if (activeChoice.hasTargetProof() && activeChoice.targetRosterHash().equals((Object)sourceRosterHash)) {
                construction = construction.copyBuilder().sourceProof(activeChoice.targetProofOrThrow()).build();
            }
            this.nextConstruction.put((Object)construction);
            this.logNewConstruction(construction, InSlot.NEXT, sourceRosterHash, targetRosterHash);
        }
        Timestamp adoptionTime = HapiUtils.asTimestamp((Instant)now);
        Roster targetRoster = Objects.requireNonNull(lookup.apply(targetRosterHash));
        targetRoster.rosterEntries().forEach(entry -> {
            NodeId nodeId = new NodeId(entry.nodeId());
            ProofKeySet keySet = (ProofKeySet)this.proofKeySets.get((Object)nodeId);
            if (keySet != null && keySet.nextKey().length() > 0L) {
                ProofKeySet rotatedKeySet = keySet.copyBuilder().key(keySet.nextKey()).adoptionTime(adoptionTime).nextKey(Bytes.EMPTY).build();
                this.proofKeySets.put((Object)nodeId, (Object)rotatedKeySet);
            }
        });
        return construction;
    }

    private void logNewConstruction(@NonNull HistoryProofConstruction construction, @NonNull InSlot slot, @NonNull Bytes sourceRosterHash, @NonNull Bytes targetRosterHash) {
        logger.info("Created {} construction #{} for rosters (source={}, target={}) {} source proof", (Object)slot, (Object)construction.constructionId(), (Object)sourceRosterHash, (Object)targetRosterHash, (Object)(construction.hasSourceProof() ? "WITH" : "WITHOUT"));
    }

    private void purgeVotesAndSignatures(long constructionId, @NonNull Roster sourceRoster) {
        sourceRoster.rosterEntries().forEach(entry -> {
            ConstructionNodeId key = new ConstructionNodeId(constructionId, entry.nodeId());
            this.votes.remove((Object)key);
            this.signatures.remove((Object)key);
        });
    }

    private long newConstructionId() {
        return Math.max(Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get()).constructionId(), Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).constructionId()) + 1L;
    }

    private static enum InSlot {
        ACTIVE,
        NEXT;

    }
}

