/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.recordcache.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.recordcache.TransactionReceiptEntries;
import com.hedera.hapi.node.state.recordcache.TransactionReceiptEntry;
import com.hedera.hapi.node.state.recordcache.TransactionRecordEntry;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.WritableQueueState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V0540RecordCacheSchema
extends Schema {
    private static final Logger log = LogManager.getLogger(V0540RecordCacheSchema.class);
    public static final String TXN_RECEIPT_QUEUE = "TransactionReceiptQueue";
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(54).patch(0).build();

    public V0540RecordCacheSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.queue((String)TXN_RECEIPT_QUEUE, (Codec)TransactionReceiptEntries.PROTOBUF));
    }

    @NonNull
    public Set<String> statesToRemove() {
        return Set.of("TransactionRecordQueue");
    }

    public void migrate(@NonNull MigrationContext ctx) {
        ReadableQueueState recordQueue = ctx.previousStates().getQueue("TransactionRecordQueue");
        WritableQueueState receiptQueue = ctx.newStates().getQueue(TXN_RECEIPT_QUEUE);
        ArrayList<TransactionReceiptEntry> receipts = new ArrayList<TransactionReceiptEntry>();
        for (TransactionRecordEntry recordEntry : recordQueue) {
            TransactionRecord record = recordEntry.transactionRecord();
            TransactionReceiptEntry receipt = TransactionReceiptEntry.newBuilder().status(record.receiptOrElse(TransactionReceipt.DEFAULT).status()).nodeId(recordEntry.nodeId()).transactionId(record.transactionID()).build();
            receipts.add(receipt);
        }
        if (!receipts.isEmpty()) {
            TransactionReceiptEntries entries = TransactionReceiptEntries.newBuilder().entries(receipts).build();
            receiptQueue.add((Object)entries);
            log.info("Migrated {} records from {} to {}", (Object)receipts.size(), (Object)"TransactionRecordQueue", (Object)TXN_RECEIPT_QUEUE);
        } else {
            log.info("No records to migrate from {} to {}", (Object)"TransactionRecordQueue", (Object)TXN_RECEIPT_QUEUE);
        }
    }
}

