/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.hapi.node.token.TokenAllowance;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.GrantApprovalTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GrantApprovalDecoder {
    @Inject
    public GrantApprovalDecoder() {
    }

    public TransactionBody decodeGrantApproval(@NonNull HtsCallAttempt attempt) {
        Tuple call = GrantApprovalTranslator.GRANT_APPROVAL.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().transactionID(TransactionID.newBuilder().accountID(attempt.senderId()).build()).cryptoApproveAllowance(this.grantApproval(attempt, (Address)call.get(0), (Address)call.get(1), (BigInteger)call.get(2))).build();
    }

    public TransactionBody decodeGrantApprovalNFT(@NonNull HtsCallAttempt attempt) {
        Tuple call = GrantApprovalTranslator.GRANT_APPROVAL_NFT.decodeCall(attempt.inputBytes());
        return TransactionBody.newBuilder().transactionID(TransactionID.newBuilder().accountID(attempt.senderId()).build()).cryptoApproveAllowance(this.grantApprovalNFT(attempt, (Address)call.get(0), (Address)call.get(1), (BigInteger)call.get(2))).build();
    }

    private CryptoApproveAllowanceTransactionBody grantApproval(@NonNull HtsCallAttempt attempt, @NonNull Address token, @NonNull Address spender, @NonNull BigInteger amount) {
        return CryptoApproveAllowanceTransactionBody.newBuilder().tokenAllowances(new TokenAllowance[]{TokenAllowance.newBuilder().tokenId(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token)).spender(attempt.addressIdConverter().convert(spender)).amount(amount.longValueExact()).build()}).build();
    }

    private CryptoApproveAllowanceTransactionBody grantApprovalNFT(@NonNull HtsCallAttempt attempt, @NonNull Address token, @NonNull Address spender, @NonNull BigInteger serialNumber) {
        return CryptoApproveAllowanceTransactionBody.newBuilder().nftAllowances(new NftAllowance[]{NftAllowance.newBuilder().tokenId(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), token)).spender(attempt.addressIdConverter().convert(spender)).serialNumbers(new Long[]{serialNumber.longValue()}).build()}).build();
    }
}

