/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class RedirectBytecodeUtils {
    private static final String ADDRESS_BYTECODE_PATTERN = "fefefefefefefefefefefefefefefefefefefefe";
    public static final String PROXY_PRE_BYTES = "6080604052348015600f57600080fd5b50600061";
    public static final String PROXY_MID_BYTES = "905077";
    private static final String PROXY_POST_BYTES = "fefefefefefefefefefefefefefefefefefefefe600052366000602037600080366018016008845af43d806000803e8160008114605857816000f35b816000fdfea2646970667358221220d8378feed472ba49a0005514ef7087017f707b45fb9bf56bb81bb93ff19a238b64736f6c634300080b0033";
    private static final String TOKEN_CALL_REDIRECT_CONTRACT_BINARY = "6080604052348015600f57600080fd5b506000610167905077618dc65efefefefefefefefefefefefefefefefefefefefe600052366000602037600080366018016008845af43d806000803e8160008114605857816000f35b816000fdfea2646970667358221220d8378feed472ba49a0005514ef7087017f707b45fb9bf56bb81bb93ff19a238b64736f6c634300080b0033";
    private static final String ACCOUNT_CALL_REDIRECT_CONTRACT_BINARY = "6080604052348015600f57600080fd5b50600061016a905077e4cbd3a7fefefefefefefefefefefefefefefefefefefefe600052366000602037600080366018016008845af43d806000803e8160008114605857816000f35b816000fdfea2646970667358221220d8378feed472ba49a0005514ef7087017f707b45fb9bf56bb81bb93ff19a238b64736f6c634300080b0033";
    private static final String SCHEDULE_CALL_REDIRECT_CONTRACT_BINARY = "6080604052348015600f57600080fd5b50600061016b9050775c3889cafefefefefefefefefefefefefefefefefefefefe600052366000602037600080366018016008845af43d806000803e8160008114605857816000f35b816000fdfea2646970667358221220d8378feed472ba49a0005514ef7087017f707b45fb9bf56bb81bb93ff19a238b64736f6c634300080b0033";

    private RedirectBytecodeUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static Bytes tokenProxyBytecodeFor(@NonNull Address address) {
        Objects.requireNonNull(address);
        return Bytes.fromHexString((CharSequence)TOKEN_CALL_REDIRECT_CONTRACT_BINARY.replace(ADDRESS_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes tokenProxyBytecodePjb(@Nullable Address address) {
        return address == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : com.hedera.pbj.runtime.io.buffer.Bytes.fromHex((String)TOKEN_CALL_REDIRECT_CONTRACT_BINARY.replace(ADDRESS_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }

    public static Bytes accountProxyBytecodeFor(@Nullable Address address) {
        return address == null ? Bytes.EMPTY : Bytes.fromHexString((CharSequence)ACCOUNT_CALL_REDIRECT_CONTRACT_BINARY.replace(ADDRESS_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes accountProxyBytecodePjb(@Nullable Address address) {
        return address == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : com.hedera.pbj.runtime.io.buffer.Bytes.fromHex((String)ACCOUNT_CALL_REDIRECT_CONTRACT_BINARY.replace(ADDRESS_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }

    public static Bytes scheduleProxyBytecodeFor(@Nullable Address address) {
        return address == null ? Bytes.EMPTY : Bytes.fromHexString((CharSequence)SCHEDULE_CALL_REDIRECT_CONTRACT_BINARY.replace(ADDRESS_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes scheduleProxyBytecodePjb(@Nullable Address address) {
        return address == null ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : com.hedera.pbj.runtime.io.buffer.Bytes.fromHex((String)SCHEDULE_CALL_REDIRECT_CONTRACT_BINARY.replace(ADDRESS_BYTECODE_PATTERN, address.toUnprefixedHexString()));
    }
}

