/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions;

import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConfigUtils {
    private ConfigUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static boolean haveEqualProperties(@NonNull Configuration config1, @NonNull Configuration config2) {
        Objects.requireNonNull(config1, "config1 must not be null");
        Objects.requireNonNull(config2, "config2 must not be null");
        Map<String, String> properties1 = config1.getPropertyNames().collect(Collectors.toMap(s -> s, s -> config1.getValue(s)));
        Map<String, String> properties2 = config2.getPropertyNames().collect(Collectors.toMap(s -> s, s -> config2.getValue(s)));
        return Objects.equals(properties1, properties2);
    }
}

