/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.internal;

import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.ConfigurationExtension;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.api.validation.ConfigValidator;
import com.swirlds.config.extensions.sources.SimpleConfigSource;
import com.swirlds.config.impl.internal.ConfigPropertiesService;
import com.swirlds.config.impl.internal.ConfigSourceService;
import com.swirlds.config.impl.internal.ConfigValidationService;
import com.swirlds.config.impl.internal.ConfigurationImpl;
import com.swirlds.config.impl.internal.ConverterService;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

final class ConfigurationBuilderImpl
implements ConfigurationBuilder {
    private final ReentrantLock initializationLock = new ReentrantLock();
    private final ConfigurationImpl configuration;
    private final ConfigSourceService configSourceService;
    private final ConverterService converterService;
    private final ConfigValidationService validationService;
    private final ConfigPropertiesService propertiesService;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final Map<String, String> properties = new HashMap<String, String>();

    ConfigurationBuilderImpl() {
        this.configSourceService = new ConfigSourceService();
        this.converterService = new ConverterService();
        this.propertiesService = new ConfigPropertiesService(this.configSourceService);
        this.validationService = new ConfigValidationService(this.converterService);
        this.configuration = new ConfigurationImpl(this.propertiesService, this.converterService, this.validationService);
    }

    @NonNull
    public Configuration build() {
        this.initializationLock.lock();
        try {
            if (this.initialized.get()) {
                throw new IllegalStateException("Configuration already initialized");
            }
            if (!this.properties.isEmpty()) {
                this.withSource((ConfigSource)new SimpleConfigSource(this.properties).withOrdinal(50));
            }
            this.configSourceService.init();
            this.converterService.init();
            this.propertiesService.init();
            this.validationService.init();
            this.configuration.init();
            this.initialized.set(true);
        }
        finally {
            this.initializationLock.unlock();
        }
        return this.configuration;
    }

    @NonNull
    public ConfigurationBuilder autoDiscoverExtensions() {
        ServiceLoader<ConfigurationExtension> serviceLoader = ServiceLoader.load(ConfigurationExtension.class);
        List<ConfigurationExtension> extensions = serviceLoader.stream().map(ServiceLoader.Provider::get).toList();
        for (ConfigurationExtension extension : extensions) {
            this.loadExtension(extension);
        }
        return this;
    }

    @NonNull
    public ConfigurationBuilder loadExtension(@NonNull ConfigurationExtension extension) {
        extension.getConverters().forEach(this::addConverter);
        extension.getValidators().forEach(this::addValidator);
        extension.getConfigDataTypes().forEach(this::addConfigDataType);
        extension.getConfigSources().forEach(this::addConfigSource);
        return this;
    }

    private <T> void addConverter(ConfigurationExtension.ConverterPair<T> converterPair) {
        this.addConverter(converterPair.type(), converterPair.converter());
    }

    @NonNull
    public ConfigurationBuilder withSource(@NonNull ConfigSource configSource) {
        this.addConfigSource(configSource);
        return this;
    }

    @NonNull
    public ConfigurationBuilder withSources(ConfigSource ... configSources) {
        Arrays.stream(configSources).forEach(this::addConfigSource);
        return this;
    }

    private void addConfigSource(@NonNull ConfigSource configSource) {
        Objects.requireNonNull(configSource, "configSource must not be null");
        if (this.initialized.get()) {
            throw new IllegalStateException("ConfigSource can not be added to initialized config");
        }
        this.configSourceService.addConfigSource(configSource);
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public ConfigurationBuilder withConverter(@NonNull ConfigConverter<?> converter) {
        this.addConverter(ConfigurationBuilderImpl.getConverterType(converter.getClass()), converter);
        return this;
    }

    @NonNull
    public <T> ConfigurationBuilder withConverter(@NonNull Class<T> converterType, @NonNull ConfigConverter<T> converter) {
        this.addConverter(converterType, converter);
        return this;
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public ConfigurationBuilder withConverters(ConfigConverter<?> ... converters) {
        Arrays.stream(converters).forEach(this::withConverter);
        return this;
    }

    private <T> void addConverter(@NonNull Class<T> converterType, @NonNull ConfigConverter<T> converter) {
        Objects.requireNonNull(converter, "converter must not be null");
        if (this.initialized.get()) {
            throw new IllegalStateException("Converters can not be added to initialized config");
        }
        this.converterService.addConverter(converterType, converter);
    }

    @NonNull
    public ConfigurationBuilder withValidator(@NonNull ConfigValidator validator) {
        this.addValidator(validator);
        return this;
    }

    @NonNull
    public ConfigurationBuilder withValidators(ConfigValidator ... validators) {
        Arrays.stream(validators).forEach(this::addValidator);
        return this;
    }

    private void addValidator(@NonNull ConfigValidator validator) {
        Objects.requireNonNull(validator, "validator must not be null");
        if (this.initialized.get()) {
            throw new IllegalStateException("ConfigValidator can not be added to initialized config");
        }
        this.validationService.addValidator(validator);
    }

    @NonNull
    public <T extends Record> ConfigurationBuilder withConfigDataType(@NonNull Class<T> type) {
        this.addConfigDataType(type);
        return this;
    }

    @NonNull
    public ConfigurationBuilder withConfigDataTypes(Class<? extends Record> ... types) {
        Arrays.stream(types).forEach(this::addConfigDataType);
        return this;
    }

    private <T extends Record> void addConfigDataType(@NonNull Class<T> type) {
        Objects.requireNonNull(type, "type must not be null");
        if (this.initialized.get()) {
            throw new IllegalStateException("ConfigDataType can not be added to initialized config");
        }
        this.configuration.addConfigDataType(type);
    }

    @NonNull
    public ConfigurationBuilder withValue(@NonNull String propertyName, @NonNull String value) {
        Objects.requireNonNull(propertyName, "propertyName must not be null");
        Objects.requireNonNull(value, "value must not be null");
        this.properties.put(propertyName, value);
        return this;
    }

    @NonNull
    private static <T, C extends ConfigConverter<T>> Class<T> getConverterType(@NonNull Class<C> converterClass) {
        Objects.requireNonNull(converterClass, "converterClass must not be null");
        return Arrays.stream(converterClass.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(parameterizedType -> Objects.equals(ConfigConverter.class, parameterizedType.getRawType())).map(ParameterizedType::getActualTypeArguments).findAny().map(typeArguments -> {
            if (((Type[])typeArguments).length != 1) {
                throw new IllegalStateException("Can not extract generic type for converter " + String.valueOf(converterClass));
            }
            return (Class)typeArguments[0];
        }).orElseGet(() -> ConfigurationBuilderImpl.getConverterType(converterClass.getSuperclass()));
    }
}

