/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.report;

import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.platform.event.report.EventStreamInfo;
import com.swirlds.platform.event.report.EventStreamReport;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class EventStreamMultiNodeReport {
    private final Map<String, EventStreamInfo> individualReports = new HashMap<String, EventStreamInfo>();

    public void addIndividualReport(@NonNull Path directory, @NonNull EventStreamReport individualReport) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(individualReport);
        this.individualReports.put(directory.toString(), individualReport.summary());
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        Map.Entry entryWithLatestEvent = this.individualReports.entrySet().stream().max(Map.Entry.comparingByValue((o1, o2) -> {
            Instant o1Timestamp = o1.lastEvent().getPlatformEvent().getConsensusTimestamp();
            Instant o2Timestamp = o2.lastEvent().getPlatformEvent().getConsensusTimestamp();
            return o1Timestamp.compareTo(o2Timestamp);
        })).orElseThrow();
        Map.Entry entryWithMostEvents = this.individualReports.entrySet().stream().max(Map.Entry.comparingByValue(Comparator.comparingLong(EventStreamInfo::eventCount))).orElseThrow();
        new TextTable().setTitle("Multi-node Event Stream Summary").addRow(new Object[]{TextEffect.BRIGHT_RED.apply("Directory with latest event"), entryWithLatestEvent.getKey()}).addRow(new Object[]{TextEffect.BRIGHT_YELLOW.apply("Latest event consensus timestamp"), ((EventStreamInfo)entryWithLatestEvent.getValue()).lastEvent().getPlatformEvent().getConsensusTimestamp()}).addRow(new Object[]{TextEffect.BRIGHT_RED.apply("Directory with most events"), entryWithMostEvents.getKey()}).addRow(new Object[]{TextEffect.BRIGHT_YELLOW.apply("Number of events"), entryWithMostEvents.getValue().eventCount()}).render(sb);
        sb.append("\n\n");
        return sb.toString();
    }
}

