/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.model.roster.AddressBook;

public class StandardGuiSource
implements HashgraphGuiSource {
    private final AddressBook addressBook;
    private final GuiEventStorage eventStorage;

    public StandardGuiSource(@NonNull AddressBook addressBook, @NonNull GuiEventStorage eventStorage) {
        this.addressBook = Objects.requireNonNull(addressBook);
        this.eventStorage = Objects.requireNonNull(eventStorage);
    }

    @Override
    public long getMaxGeneration() {
        return this.eventStorage.getMaxGeneration();
    }

    @Override
    @NonNull
    public List<EventImpl> getEvents(long startGeneration, int numGenerations) {
        return this.eventStorage.getNonAncientEvents().stream().filter(e -> e.getNGen() >= startGeneration && e.getNGen() < startGeneration + (long)numGenerations).toList();
    }

    @Override
    @NonNull
    public AddressBook getAddressBook() {
        return this.addressBook;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public GuiEventStorage getEventStorage() {
        return this.eventStorage;
    }
}

