/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.proof.tree;

import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.platform.proof.tree.AbstractStateProofNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.security.MessageDigest;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.SerializableHashable;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class StateProofPayload
extends AbstractStateProofNode
implements SelfSerializable {
    private static final long CLASS_ID = -3307769763825469673L;
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    private MerkleLeaf payload;
    private boolean initialized = false;

    public StateProofPayload() {
    }

    public StateProofPayload(@Nullable MerkleLeaf payload) {
        if (payload != null && payload.getHash() == null) {
            throw new IllegalArgumentException("Payload must be hashed");
        }
        this.payload = payload;
        this.initialized = true;
    }

    @NonNull
    public MerkleLeaf getPayload() {
        return this.payload;
    }

    @Override
    public void computeHashableBytes(@NonNull MessageDigest digest) {
        if (!this.initialized) {
            throw new IllegalStateException("StateProofPayload has not been properly initialized");
        }
        if (this.payload.getHash() == null) {
            CRYPTOGRAPHY.digestSync((SerializableHashable)this.payload);
        }
        this.setHashableBytes(this.payload.getHash().copyToByteArray());
    }

    public long getClassId() {
        return -3307769763825469673L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        out.writeSerializable((SelfSerializable)this.payload, true);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.payload = (MerkleLeaf)in.readSerializable();
        this.initialized = true;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

