/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.iss;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.component.framework.component.InputWireLabel;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.system.status.actions.CatastrophicFailureAction;
import com.swirlds.platform.system.status.actions.PlatformStatusAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;

public interface IssDetector {
    public static final int DO_NOT_IGNORE_ROUNDS = -1;

    public void signalEndOfPreconsensusReplay();

    @InputWireLabel(value="post consensus state signatures")
    @Nullable
    public List<IssNotification> handleStateSignatureTransactions(@NonNull Collection<ScopedSystemTransaction<StateSignatureTransaction>> var1);

    @InputWireLabel(value="hashed states")
    @Nullable
    public List<IssNotification> handleState(@NonNull ReservedSignedState var1);

    @Nullable
    public List<IssNotification> overridingState(@NonNull ReservedSignedState var1);

    @Nullable
    default public PlatformStatusAction getStatusAction(IssNotification notification) {
        if (Set.of(IssNotification.IssType.SELF_ISS, IssNotification.IssType.CATASTROPHIC_ISS).contains(notification.getIssType())) {
            return new CatastrophicFailureAction();
        }
        return null;
    }
}

