/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import java.nio.ByteOrder;

public final class Bytes {
    public static final byte COLON_BYTE = 58;
    public static final byte SPACE_BYTE = 32;
    public static final byte LF_BYTE = 10;
    public static final byte CR_BYTE = 13;
    public static final byte SLASH_BYTE = 47;
    public static final byte SEMICOLON_BYTE = 59;
    public static final byte QUESTION_MARK_BYTE = 63;
    public static final byte HASH_BYTE = 35;
    public static final byte EQUALS_BYTE = 61;
    public static final byte AMPERSAND_BYTE = 38;
    public static final byte PERCENT_BYTE = 37;
    public static final byte TAB_BYTE = 9;
    private static final boolean BYTE_ORDER_LE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    private Bytes() {
    }

    public static int firstIndexOf(byte[] buffer, int fromIndex, int toIndex, byte value) {
        if (fromIndex == toIndex || buffer.length == 0) {
            return -1;
        }
        int length = toIndex - fromIndex;
        int offset = fromIndex;
        int byteCount = length & 7;
        if (byteCount > 0) {
            int index = Bytes.unrolledFirstIndexOf(buffer, fromIndex, byteCount, value);
            if (index != -1) {
                return index;
            }
            if ((offset += byteCount) == toIndex) {
                return -1;
            }
        }
        int longCount = length >>> 3;
        long pattern = Bytes.compilePattern(value);
        for (int i = 0; i < longCount; ++i) {
            long word = Bytes.toWord(buffer, offset);
            int index = Bytes.firstInstance(word, pattern);
            if (index < 8) {
                return offset + index;
            }
            offset += 8;
        }
        return -1;
    }

    public static long toWord(byte[] buffer, int offset) {
        return BYTE_ORDER_LE ? Bytes.toWordLe(buffer, offset) : Bytes.toWordBe(buffer, offset);
    }

    private static long compilePattern(byte byteToFind) {
        return ((long)byteToFind & 0xFFL) * 0x101010101010101L;
    }

    private static int firstInstance(long word, long pattern) {
        long input = word ^ pattern;
        long tmp = (input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
        tmp = (tmp | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
        int binaryPosition = Long.numberOfTrailingZeros(tmp);
        return binaryPosition >>> 3;
    }

    private static long toWordLe(byte[] buffer, int index) {
        return (long)buffer[index] & 0xFFL | ((long)buffer[index + 1] & 0xFFL) << 8 | ((long)buffer[index + 2] & 0xFFL) << 16 | ((long)buffer[index + 3] & 0xFFL) << 24 | ((long)buffer[index + 4] & 0xFFL) << 32 | ((long)buffer[index + 5] & 0xFFL) << 40 | ((long)buffer[index + 6] & 0xFFL) << 48 | ((long)buffer[index + 7] & 0xFFL) << 56;
    }

    private static long toWordBe(byte[] buffer, int index) {
        return ((long)buffer[index] & 0xFFL) << 56 | ((long)buffer[index + 1] & 0xFFL) << 48 | ((long)buffer[index + 2] & 0xFFL) << 40 | ((long)buffer[index + 3] & 0xFFL) << 32 | ((long)buffer[index + 4] & 0xFFL) << 24 | ((long)buffer[index + 5] & 0xFFL) << 16 | ((long)buffer[index + 6] & 0xFFL) << 8 | (long)buffer[index + 7] & 0xFFL;
    }

    private static int unrolledFirstIndexOf(byte[] buffer, int fromIndex, int byteCount, byte value) {
        assert (byteCount > 0 && byteCount < 8);
        if (buffer[fromIndex] == value) {
            return fromIndex;
        }
        if (byteCount == 1) {
            return -1;
        }
        if (buffer[fromIndex + 1] == value) {
            return fromIndex + 1;
        }
        if (byteCount == 2) {
            return -1;
        }
        if (buffer[fromIndex + 2] == value) {
            return fromIndex + 2;
        }
        if (byteCount == 3) {
            return -1;
        }
        if (buffer[fromIndex + 3] == value) {
            return fromIndex + 3;
        }
        if (byteCount == 4) {
            return -1;
        }
        if (buffer[fromIndex + 4] == value) {
            return fromIndex + 4;
        }
        if (byteCount == 5) {
            return -1;
        }
        if (buffer[fromIndex + 5] == value) {
            return fromIndex + 5;
        }
        if (byteCount == 6) {
            return -1;
        }
        if (buffer[fromIndex + 6] == value) {
            return fromIndex + 6;
        }
        return -1;
    }
}

