/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.ContractIDJsonCodec;
import com.hedera.hapi.node.base.codec.ContractIDProtoCodec;
import com.hedera.hapi.node.base.schema.ContractIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ContractID {
    public static final Codec<ContractID> PROTOBUF = new ContractIDProtoCodec();
    public static final JsonCodec<ContractID> JSON = new ContractIDJsonCodec();
    public static final ContractID DEFAULT = ContractID.newBuilder().build();
    private final long shardNum;
    private final long realmNum;
    private final OneOf<ContractOneOfType> contract;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public ContractID(long shardNum, long realmNum, OneOf<ContractOneOfType> contract) {
        this.$unknownFields = null;
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        if (contract == null) {
            throw new NullPointerException("Parameter 'contract' must be supplied and can not be null");
        }
        this.contract = contract;
    }

    public ContractID(long shardNum, long realmNum, OneOf<ContractOneOfType> contract, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        if (contract == null) {
            throw new NullPointerException("Parameter 'contract' must be supplied and can not be null");
        }
        this.contract = contract;
    }

    public long shardNum() {
        return this.shardNum;
    }

    public long realmNum() {
        return this.realmNum;
    }

    public OneOf<ContractOneOfType> contract() {
        return this.contract;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractIDSchema.SHARD_NUM, (long)this.shardNum, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractIDSchema.REALM_NUM, (long)this.realmNum, (boolean)true);
            if (this.contract.kind() == ContractOneOfType.CONTRACT_NUM) {
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractIDSchema.CONTRACT_NUM, (long)((Long)this.contract.as()), (boolean)true);
            }
            if (this.contract.kind() == ContractOneOfType.EVM_ADDRESS) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractIDSchema.EVM_ADDRESS, (RandomAccessData)((RandomAccessData)this.contract.as()), (boolean)true);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.shardNum != ContractID.DEFAULT.shardNum) {
                result = 31 * result + Long.hashCode(this.shardNum);
            }
            if (this.realmNum != ContractID.DEFAULT.realmNum) {
                result = 31 * result + Long.hashCode(this.realmNum);
            }
            if (this.contract != null && !this.contract.equals(ContractID.DEFAULT.contract)) {
                result = 31 * result + this.contract.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractID thatObj = (ContractID)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.shardNum != thatObj.shardNum) {
            return false;
        }
        if (this.realmNum != thatObj.realmNum) {
            return false;
        }
        if (this.contract == null && thatObj.contract != null) {
            return false;
        }
        if (this.contract != null && !this.contract.equals(thatObj.contract)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "ContractID[shardNum=" + this.shardNum + ", realmNum=" + this.realmNum + ", contract=" + String.valueOf(this.contract) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public Long contractNum() {
        return this.contract.kind() == ContractOneOfType.CONTRACT_NUM ? (Long)this.contract.value() : null;
    }

    public boolean hasContractNum() {
        return this.contract.kind() == ContractOneOfType.CONTRACT_NUM;
    }

    public Long contractNumOrElse(@NonNull Long defaultValue) {
        return this.hasContractNum() ? this.contractNum() : defaultValue;
    }

    @NonNull
    public Long contractNumOrThrow() {
        return Objects.requireNonNull(this.contractNum(), "Field contractNum is null");
    }

    @Nullable
    public Bytes evmAddress() {
        return this.contract.kind() == ContractOneOfType.EVM_ADDRESS ? (Bytes)this.contract.value() : null;
    }

    public boolean hasEvmAddress() {
        return this.contract.kind() == ContractOneOfType.EVM_ADDRESS;
    }

    public Bytes evmAddressOrElse(@NonNull Bytes defaultValue) {
        return this.hasEvmAddress() ? this.evmAddress() : defaultValue;
    }

    @NonNull
    public Bytes evmAddressOrThrow() {
        return Objects.requireNonNull(this.evmAddress(), "Field evmAddress is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.shardNum, this.realmNum, this.contract, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ContractOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT_NUM(3, "contractNum"),
        EVM_ADDRESS(4, "evm_address");

        private final int protoOrdinal;
        private final String protoName;

        private ContractOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ContractOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 3 -> CONTRACT_NUM;
                case 4 -> EVM_ADDRESS;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static ContractOneOfType fromString(String name) {
            return switch (name) {
                case "contractNum", "CONTRACT_NUM" -> CONTRACT_NUM;
                case "evm_address", "EVM_ADDRESS" -> EVM_ADDRESS;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private long shardNum = 0L;
        private long realmNum = 0L;
        private OneOf<ContractOneOfType> contract = ContractIDProtoCodec.CONTRACT_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long shardNum, long realmNum, OneOf<ContractOneOfType> contract) {
            this.$unknownFields = null;
            this.shardNum = shardNum;
            this.realmNum = realmNum;
            this.contract = contract;
        }

        public Builder(long shardNum, long realmNum, OneOf<ContractOneOfType> contract, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.shardNum = shardNum;
            this.realmNum = realmNum;
            this.contract = contract;
        }

        public ContractID build() {
            return new ContractID(this.shardNum, this.realmNum, this.contract);
        }

        public Builder shardNum(long shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public Builder realmNum(long realmNum) {
            this.realmNum = realmNum;
            return this;
        }

        public Builder contractNum(long contractNum) {
            this.contract = new OneOf((Enum)ContractOneOfType.CONTRACT_NUM, (Object)contractNum);
            return this;
        }

        public Builder evmAddress(@NonNull Bytes evmAddress) {
            this.contract = new OneOf((Enum)ContractOneOfType.EVM_ADDRESS, (Object)evmAddress);
            return this;
        }
    }
}

