/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.DoubleAccumulator;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MerkleDbStatistics {
    public static final String STAT_CATEGORY = "merkle_db";
    private static final String DS_PREFIX = "ds_";
    private static final String FILES_PREFIX = "files_";
    private static final String READS_PREFIX = "reads_";
    private static final String FLUSHES_PREFIX = "flushes_";
    private static final String COMPACTIONS_PREFIX = "compactions_";
    private static final String LEVEL_PREFIX = "level_";
    private static final String OFFHEAP_PREFIX = "offheap_";
    private final MerkleDbConfig dbConfig;
    private final String label;
    private LongAccumulator hashReads;
    private LongAccumulator leafReads;
    private LongAccumulator leafKeyReads;
    private IntegerGauge hashesStoreFileCount;
    private IntegerGauge hashesStoreFileSizeMb;
    private IntegerGauge leavesStoreFileCount;
    private IntegerGauge leavesStoreFileSizeMb;
    private IntegerGauge leafKeysStoreFileCount;
    private IntegerGauge leafKeysStoreFileSizeMb;
    private IntegerGauge totalFileSizeMb;
    private LongAccumulator flushHashesWritten;
    private DoubleAccumulator flushHashesStoreFileSizeMb;
    private LongAccumulator flushLeavesWritten;
    private LongAccumulator flushLeavesDeleted;
    private DoubleAccumulator flushLeavesStoreFileSizeMb;
    private LongAccumulator flushLeafKeysWritten;
    private DoubleAccumulator flushLeafKeysStoreFileSizeMb;
    private final List<LongAccumulator> hashesStoreCompactionTimeMsList;
    private final List<DoubleAccumulator> hashesStoreCompactionSavedSpaceMbList;
    private final List<DoubleAccumulator> hashesStoreFileSizeByLevelMbList;
    private final List<LongAccumulator> leavesStoreCompactionTimeMsList;
    private final List<DoubleAccumulator> leavesStoreCompactionSavedSpaceMbList;
    private final List<DoubleAccumulator> leavesStoreFileSizeByLevelMbList;
    private final List<LongAccumulator> leafKeysStoreCompactionTimeMsList;
    private final List<DoubleAccumulator> leafKeysStoreCompactionSavedSpaceMbList;
    private final List<DoubleAccumulator> leafKeysStoreFileSizeByLevelMbList;
    private IntegerGauge offHeapHashesIndexMb;
    private IntegerGauge offHeapLeavesIndexMb;
    private IntegerGauge offHeapObjectKeyBucketsIndexMb;
    private IntegerGauge offHeapHashesListMb;
    private IntegerGauge offHeapDataSourceMb;

    public MerkleDbStatistics(MerkleDbConfig dbConfig, String label) {
        this.dbConfig = dbConfig;
        Objects.requireNonNull(label, "label must not be null");
        this.label = label.replace('.', '_');
        this.hashesStoreCompactionTimeMsList = new ArrayList<LongAccumulator>();
        this.hashesStoreCompactionSavedSpaceMbList = new ArrayList<DoubleAccumulator>();
        this.hashesStoreFileSizeByLevelMbList = new ArrayList<DoubleAccumulator>();
        this.leavesStoreCompactionTimeMsList = new ArrayList<LongAccumulator>();
        this.leavesStoreCompactionSavedSpaceMbList = new ArrayList<DoubleAccumulator>();
        this.leavesStoreFileSizeByLevelMbList = new ArrayList<DoubleAccumulator>();
        this.leafKeysStoreCompactionTimeMsList = new ArrayList<LongAccumulator>();
        this.leafKeysStoreCompactionSavedSpaceMbList = new ArrayList<DoubleAccumulator>();
        this.leafKeysStoreFileSizeByLevelMbList = new ArrayList<DoubleAccumulator>();
    }

    private static IntegerGauge buildIntegerGauge(Metrics metrics, String name, String description) {
        return (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, name).withDescription(description));
    }

    private static LongAccumulator buildLongAccumulator(Metrics metrics, String name, String description) {
        return (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config(STAT_CATEGORY, name).withInitialValue(0L).withAccumulator(Long::sum).withDescription(description));
    }

    private static DoubleAccumulator buildDoubleAccumulator(Metrics metrics, String name, String description) {
        return (DoubleAccumulator)metrics.getOrCreate((MetricConfig)new DoubleAccumulator.Config(STAT_CATEGORY, name).withInitialValue(0.0).withAccumulator(Double::sum).withDescription(description).withFormat("%,9.6f"));
    }

    public void registerMetrics(Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.hashReads = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_reads_hashes_" + this.label, "Number of hash reads, " + this.label);
        this.leafReads = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_reads_leaves_" + this.label, "Number of leaf reads, " + this.label);
        this.leafKeyReads = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_reads_leafKeys_" + this.label, "Number of leaf key reads, " + this.label);
        this.hashesStoreFileCount = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_files_hashesStoreFileCount_" + this.label).withDescription("File count, hashes store, " + this.label));
        this.hashesStoreFileSizeMb = MerkleDbStatistics.buildIntegerGauge(metrics, "ds_files_hashesStoreFileSizeMb_" + this.label, "File size, hashes store, " + this.label + ", Mb");
        this.leavesStoreFileCount = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_files_leavesStoreFileCount_" + this.label).withDescription("File count, leaf keys store, " + this.label));
        this.leavesStoreFileSizeMb = MerkleDbStatistics.buildIntegerGauge(metrics, "ds_files_leavesStoreFileSizeMb_" + this.label, "File size, leaf keys store, " + this.label + ", Mb");
        this.leafKeysStoreFileCount = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_files_leafKeysStoreFileCount_" + this.label).withDescription("File count, leaves store, " + this.label));
        this.leafKeysStoreFileSizeMb = MerkleDbStatistics.buildIntegerGauge(metrics, "ds_files_leafKeysStoreFileSizeMb_" + this.label, "File size, leaves store, " + this.label + ", Mb");
        this.totalFileSizeMb = MerkleDbStatistics.buildIntegerGauge(metrics, "ds_files_totalSizeMb_" + this.label, "Total file size, data source, " + this.label + ", Mb");
        this.flushHashesWritten = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_flushes_hashesWritten_" + this.label, "Number of hashes written during flush, " + this.label);
        this.flushHashesStoreFileSizeMb = MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_flushes_hashesStoreFileSizeMb_" + this.label, "Size of the new hashes store file created during flush, " + this.label + ", Mb");
        this.flushLeavesWritten = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_flushes_leavesWritten_" + this.label, "Number of leaves written during flush, " + this.label);
        this.flushLeavesDeleted = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_flushes_leavesDeleted_" + this.label, "Number of leaves deleted during flush, " + this.label);
        this.flushLeavesStoreFileSizeMb = MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_flushes_leavesStoreFileSizeMb_" + this.label, "Size of the new leaves store file created during flush, " + this.label + ", Mb");
        this.flushLeafKeysWritten = MerkleDbStatistics.buildLongAccumulator(metrics, "ds_flushes_leafKeysWritten_" + this.label, "Number of leaf keys written during flush, " + this.label);
        this.flushLeafKeysStoreFileSizeMb = MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_flushes_leafKeysStoreFileSizeMb_" + this.label, "Size of the new leaf keys store file created during flush, " + this.label + ", Mb");
        for (int level = 0; level <= this.dbConfig.maxCompactionLevel(); ++level) {
            this.hashesStoreCompactionTimeMsList.add(MerkleDbStatistics.buildLongAccumulator(metrics, "ds_compactions_level_" + level + "_hashesTimeMs_" + this.label, "Compactions time of level %s, hashes store, %s, ms".formatted(level, this.label)));
            this.hashesStoreCompactionSavedSpaceMbList.add(MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_compactions_level_" + level + "_hashesSavedSpaceMb_" + this.label, "Saved space during compactions of level %s, hashes store, %s, Mb".formatted(level, this.label)));
            this.hashesStoreFileSizeByLevelMbList.add(MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_files_level_" + level + "_hashesFileSizeByLevelMb_" + this.label, "Total space taken by files of level %s, hashes store, %s, Mb".formatted(level, this.label)));
            this.leavesStoreCompactionTimeMsList.add(MerkleDbStatistics.buildLongAccumulator(metrics, "ds_compactions_level_" + level + "_leavesTimeMs_" + this.label, "Compactions time of level %s, leaves store, %s, ms".formatted(level, this.label)));
            this.leavesStoreCompactionSavedSpaceMbList.add(MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_compactions_level_" + level + "_leavesSavedSpaceMb_" + this.label, "Saved space during compactions of level %s, leaves store, %s, Mb".formatted(level, this.label)));
            this.leavesStoreFileSizeByLevelMbList.add(MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_files_level_" + level + "_leavesFileSizeByLevelMb_" + this.label, "Total space taken by files of level %s, leaves store, %s, Mb".formatted(level, this.label)));
            this.leafKeysStoreCompactionTimeMsList.add(MerkleDbStatistics.buildLongAccumulator(metrics, "ds_compactions_level_" + level + "_leafKeysTimeMs_" + this.label, "Compactions time of level %s, leaf keys store, %s, ms".formatted(level, this.label)));
            this.leafKeysStoreCompactionSavedSpaceMbList.add(MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_compactions_level_" + level + "_leafKeysSavedSpaceMb_" + this.label, "Saved space during compactions of level %s, leaf keys store, %s, Mb".formatted(level, this.label)));
            this.leafKeysStoreFileSizeByLevelMbList.add(MerkleDbStatistics.buildDoubleAccumulator(metrics, "ds_files_level_" + level + "_leafKeysFileSizeByLevelMb_" + this.label, "Total space taken by files of level %s, leaf keys store, %s, Mb".formatted(level, this.label)));
        }
        this.offHeapHashesIndexMb = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_offheap_hashesIndexMb_" + this.label).withDescription("Off-heap usage, hashes store index, " + this.label + ", Mb"));
        this.offHeapLeavesIndexMb = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_offheap_leavesIndexMb_" + this.label).withDescription("Off-heap usage, leaves store index, " + this.label + ", Mb"));
        this.offHeapObjectKeyBucketsIndexMb = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_offheap_objectKeyBucketsIndexMb_" + this.label).withDescription("Off-heap usage, object leaf key buckets store index, " + this.label + ", Mb"));
        this.offHeapHashesListMb = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_offheap_hashesListMb_" + this.label).withDescription("Off-heap usage, hashes list, " + this.label + ", Mb"));
        this.offHeapDataSourceMb = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "ds_offheap_dataSourceMb_" + this.label).withDescription("Off-heap usage, data source, " + this.label + ", Mb"));
    }

    public void countHashReads() {
        if (this.hashReads != null) {
            this.hashReads.update(1L);
        }
    }

    public void countLeafReads() {
        if (this.leafReads != null) {
            this.leafReads.update(1L);
        }
    }

    public void countLeafKeyReads() {
        if (this.leafKeyReads != null) {
            this.leafKeyReads.update(1L);
        }
    }

    public void setHashesStoreFileCount(int value) {
        if (this.hashesStoreFileCount != null) {
            this.hashesStoreFileCount.set(value);
        }
    }

    public void setHashesStoreFileSizeMb(int value) {
        if (this.hashesStoreFileSizeMb != null) {
            this.hashesStoreFileSizeMb.set(value);
        }
    }

    public void setLeafKeysStoreFileCount(int value) {
        if (this.leafKeysStoreFileCount != null) {
            this.leafKeysStoreFileCount.set(value);
        }
    }

    public void setLeafKeysStoreFileSizeMb(int value) {
        if (this.leafKeysStoreFileSizeMb != null) {
            this.leafKeysStoreFileSizeMb.set(value);
        }
    }

    public void setLeavesStoreFileCount(int value) {
        if (this.leavesStoreFileCount != null) {
            this.leavesStoreFileCount.set(value);
        }
    }

    public void setLeavesStoreFileSizeMb(int value) {
        if (this.leavesStoreFileSizeMb != null) {
            this.leavesStoreFileSizeMb.set(value);
        }
    }

    public void setTotalFileSizeMb(int value) {
        if (this.totalFileSizeMb != null) {
            this.totalFileSizeMb.set(value);
        }
    }

    public void countFlushHashesWritten(long value) {
        if (this.flushHashesWritten != null) {
            this.flushHashesWritten.update(value);
        }
    }

    public void setFlushHashesStoreFileSizeMb(double value) {
        if (this.flushHashesStoreFileSizeMb != null) {
            this.flushHashesStoreFileSizeMb.update(value);
        }
    }

    public void countFlushLeavesWritten(long value) {
        if (this.flushLeavesWritten != null) {
            this.flushLeavesWritten.update(value);
        }
    }

    public void countFlushLeavesDeleted(long value) {
        if (this.flushLeavesDeleted != null) {
            this.flushLeavesDeleted.update(value);
        }
    }

    public void setFlushLeavesStoreFileSizeMb(double value) {
        if (this.flushLeavesStoreFileSizeMb != null) {
            this.flushLeavesStoreFileSizeMb.update(value);
        }
    }

    public void countFlushLeafKeysWritten(long value) {
        if (this.flushLeafKeysWritten != null) {
            this.flushLeafKeysWritten.update(value);
        }
    }

    public void setFlushLeafKeysStoreFileSizeMb(double value) {
        if (this.flushLeafKeysStoreFileSizeMb != null) {
            this.flushLeafKeysStoreFileSizeMb.update(value);
        }
    }

    public void setHashesStoreCompactionTimeMs(Integer compactionLevel, long value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.hashesStoreCompactionTimeMsList.isEmpty()) {
            return;
        }
        this.hashesStoreCompactionTimeMsList.get(compactionLevel).update(value);
    }

    public void setHashesStoreCompactionSavedSpaceMb(int compactionLevel, double value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.hashesStoreCompactionSavedSpaceMbList.isEmpty()) {
            return;
        }
        this.hashesStoreCompactionSavedSpaceMbList.get(compactionLevel).update(value);
    }

    public void setHashesStoreFileSizeByLevelMb(int compactionLevel, double value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.hashesStoreFileSizeByLevelMbList.isEmpty()) {
            return;
        }
        this.hashesStoreFileSizeByLevelMbList.get(compactionLevel).update(value);
    }

    public void setLeavesStoreCompactionTimeMs(int compactionLevel, long value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.leavesStoreCompactionTimeMsList.isEmpty()) {
            return;
        }
        this.leavesStoreCompactionTimeMsList.get(compactionLevel).update(value);
    }

    public void setLeavesStoreCompactionSavedSpaceMb(int compactionLevel, double value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.leavesStoreCompactionSavedSpaceMbList.isEmpty()) {
            return;
        }
        this.leavesStoreCompactionSavedSpaceMbList.get(compactionLevel).update(value);
    }

    public void setLeavesStoreFileSizeByLevelMb(int compactionLevel, double value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.leavesStoreFileSizeByLevelMbList.isEmpty()) {
            return;
        }
        this.leavesStoreFileSizeByLevelMbList.get(compactionLevel).update(value);
    }

    public void setLeafKeysStoreCompactionTimeMs(int compactionLevel, long value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.leafKeysStoreCompactionTimeMsList.isEmpty()) {
            return;
        }
        this.leafKeysStoreCompactionTimeMsList.get(compactionLevel).update(value);
    }

    public void setLeafKeysStoreCompactionSavedSpaceMb(int compactionLevel, double value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.leafKeysStoreCompactionSavedSpaceMbList.isEmpty()) {
            return;
        }
        this.leafKeysStoreCompactionSavedSpaceMbList.get(compactionLevel).update(value);
    }

    public void setLeafKeysStoreFileSizeByLevelMb(int compactionLevel, double value) {
        assert (compactionLevel >= 0 && compactionLevel <= this.dbConfig.maxCompactionLevel());
        if (this.leafKeysStoreFileSizeByLevelMbList.isEmpty()) {
            return;
        }
        this.leafKeysStoreFileSizeByLevelMbList.get(compactionLevel).update(value);
    }

    public void setOffHeapLeavesIndexMb(int value) {
        if (this.offHeapLeavesIndexMb != null) {
            this.offHeapLeavesIndexMb.set(value);
        }
    }

    public void setOffHeapHashesIndexMb(int value) {
        if (this.offHeapHashesIndexMb != null) {
            this.offHeapHashesIndexMb.set(value);
        }
    }

    public void setOffHeapObjectKeyBucketsIndexMb(int value) {
        if (this.offHeapObjectKeyBucketsIndexMb != null) {
            this.offHeapObjectKeyBucketsIndexMb.set(value);
        }
    }

    public void setOffHeapHashesListMb(int value) {
        if (this.offHeapHashesListMb != null) {
            this.offHeapHashesListMb.set(value);
        }
    }

    public void setOffHeapDataSourceMb(int value) {
        if (this.offHeapDataSourceMb != null) {
            this.offHeapDataSourceMb.set(value);
        }
    }
}

