/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files.hashmap;

import com.swirlds.merkledb.files.hashmap.Bucket;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;

public class ReusableBucketPool {
    private static final int DEFAULT_POOL_SIZE = 64;
    private final ConcurrentLinkedDeque<Bucket> buckets;
    private final Function<ReusableBucketPool, Bucket> newBucketSupplier;

    public ReusableBucketPool(Function<ReusableBucketPool, Bucket> bucketSupplier) {
        this(64, bucketSupplier);
    }

    public ReusableBucketPool(int size, Function<ReusableBucketPool, Bucket> bucketSupplier) {
        this.newBucketSupplier = bucketSupplier;
        this.buckets = new ConcurrentLinkedDeque();
        for (int i = 0; i < size; ++i) {
            this.buckets.offerLast(bucketSupplier.apply(this));
        }
    }

    public Bucket getBucket() {
        Bucket bucket = this.buckets.pollLast();
        if (bucket == null) {
            bucket = this.newBucketSupplier.apply(this);
        }
        bucket.clear();
        return bucket;
    }

    public void releaseBucket(Bucket bucket) {
        this.buckets.offerLast(bucket);
    }
}

