/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ABIParser {
    final int flags;
    final Set<TypeEnum> types;
    final transient boolean requiresDigest;

    public ABIParser() {
        this(0, null);
    }

    public ABIParser(int flags) {
        this(flags, null);
    }

    public ABIParser(Set<TypeEnum> types) {
        this(0, types);
    }

    public ABIParser(int flags, Set<TypeEnum> types) {
        this.flags = flags;
        if (types == null) {
            this.types = ABIJSON._ALL;
            this.requiresDigest = true;
        } else {
            this.types = EnumSet.copyOf(types);
            this.requiresDigest = this.types.contains((Object)TypeEnum.FUNCTION) || this.types.contains((Object)TypeEnum.CONSTRUCTOR) || this.types.contains((Object)TypeEnum.RECEIVE) || this.types.contains((Object)TypeEnum.FALLBACK);
        }
    }

    public <T extends ABIObject> List<T> parse(String arrayJson) {
        return this.parse(ABIJSON.reader(arrayJson));
    }

    public <T extends ABIObject> List<T> parse(InputStream arrayStream) {
        return this.parse(ABIJSON.reader(arrayStream));
    }

    public <T extends ABIObject> Stream<T> stream(String arrayJson) {
        return this.stream(ABIJSON.reader(arrayJson));
    }

    public <T extends ABIObject> Stream<T> stream(InputStream arrayStream) {
        return this.stream(ABIJSON.reader(arrayStream));
    }

    public <T extends ABIObject> List<T> parseField(String key, String objectJson) {
        return (List)this.readField(ABIJSON.reader(objectJson), key, true);
    }

    public <T extends ABIObject> List<T> parseField(String key, InputStream objectStream) {
        return (List)this.readField(ABIJSON.reader(objectStream), key, true);
    }

    public <T extends ABIObject> Stream<T> streamField(String key, String objectJson) {
        return (Stream)this.readField(ABIJSON.reader(objectJson), key, false);
    }

    public <T extends ABIObject> Stream<T> streamField(String key, InputStream objectStream) {
        return (Stream)this.readField(ABIJSON.reader(objectStream), key, false);
    }

    private <X> X readField(JsonReader reader, String key, boolean parse) {
        try {
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                if (key.equals(reader.nextName())) {
                    return (X)(parse ? this.parse(reader) : this.stream(reader));
                }
                reader.skipValue();
            }
            throw new IllegalArgumentException("key not found");
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    private <T extends ABIObject> List<T> parse(JsonReader reader) {
        Stream stream = this.stream(reader);
        List result = stream.collect(Collectors.toList());
        stream.close();
        return result;
    }

    <T extends ABIObject> Stream<T> stream(JsonReader reader) {
        try {
            return (Stream)StreamSupport.stream(new JsonSpliterator(reader), false).onClose(() -> {
                try {
                    reader.close();
                }
                catch (IOException io) {
                    throw new IllegalStateException(io);
                }
            });
        }
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (IOException io) {
                e.addSuppressed(io);
            }
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ABIParser) {
            ABIParser other = (ABIParser)o;
            return this.flags == other.flags && this.types.equals(other.types);
        }
        return false;
    }

    public int hashCode() {
        return this.flags + this.types.hashCode();
    }

    public String toString() {
        return "ABIParser{flags=" + this.flags + ", types=" + this.types + '}';
    }

    private final class JsonSpliterator<T extends ABIObject>
    implements Spliterator<T> {
        private final JsonReader reader;
        private final MessageDigest digest;

        JsonSpliterator(JsonReader reader) throws IOException {
            this.digest = ABIParser.this.requiresDigest ? Function.newDefaultDigest() : null;
            this.reader = reader;
            this.reader.beginArray();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            try {
                while (this.reader.peek() != JsonToken.END_ARRAY) {
                    Object e = ABIJSON.tryParseStreaming(this.reader, ABIParser.this.types, this.digest, ABIParser.this.flags);
                    if (e == null) continue;
                    action.accept(e);
                    return true;
                }
                this.reader.endArray();
                this.reader.close();
                return false;
            }
            catch (Exception e) {
                try {
                    this.reader.close();
                }
                catch (IOException io) {
                    e.addSuppressed(io);
                }
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

