/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.DurationGauge;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.StatEntry;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.PlatformDurationGauge;
import com.swirlds.common.metrics.platform.PlatformFunctionGauge;
import com.swirlds.common.metrics.platform.PlatformIntegerPairAccumulator;
import com.swirlds.common.metrics.platform.PlatformRunningAverageMetric;
import com.swirlds.common.metrics.platform.PlatformSpeedometerMetric;
import com.swirlds.common.metrics.platform.PlatformStatEntry;
import com.swirlds.metrics.impl.DefaultMetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class PlatformMetricsFactoryImpl
extends DefaultMetricsFactory
implements PlatformMetricsFactory {
    private final MetricsConfig metricsConfig;

    public PlatformMetricsFactoryImpl(@NonNull MetricsConfig metricsConfig) {
        this.metricsConfig = Objects.requireNonNull(metricsConfig, "metricsConfig is null");
    }

    @Override
    public DurationGauge createDurationGauge(DurationGauge.Config config) {
        return new PlatformDurationGauge(config);
    }

    @Override
    public <T> FunctionGauge<T> createFunctionGauge(FunctionGauge.Config<T> config) {
        return new PlatformFunctionGauge<T>(config);
    }

    @Override
    public <T> IntegerPairAccumulator<T> createIntegerPairAccumulator(IntegerPairAccumulator.Config<T> config) {
        return new PlatformIntegerPairAccumulator<T>(config);
    }

    @Override
    public RunningAverageMetric createRunningAverageMetric(RunningAverageMetric.Config config) {
        if (config.isUseDefaultHalfLife()) {
            return new PlatformRunningAverageMetric(config.withHalfLife(this.metricsConfig.halfLife()));
        }
        return new PlatformRunningAverageMetric(config);
    }

    @Override
    public SpeedometerMetric createSpeedometerMetric(SpeedometerMetric.Config config) {
        if (config.isUseDefaultHalfLife()) {
            return new PlatformSpeedometerMetric(config.withHalfLife(this.metricsConfig.halfLife()));
        }
        return new PlatformSpeedometerMetric(config);
    }

    @Override
    public StatEntry createStatEntry(StatEntry.Config<?> config) {
        return new PlatformStatEntry(config);
    }
}

