/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.Account;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class StakingUtilities {
    public static final long NOT_REWARDED_SINCE_LAST_STAKING_META_CHANGE = -1L;
    public static final long NO_STAKE_PERIOD_START = -1L;

    private StakingUtilities() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static long roundedToHbar(long value) {
        return value / 100000000L * 100000000L;
    }

    public static long totalStake(@NonNull Account account) {
        return account.tinybarBalance() + account.stakedToMe();
    }

    public static boolean hasStakeMetaChanges(@Nullable Account originalAccount, @NonNull Account modifiedAccount) {
        if (originalAccount == null) {
            return modifiedAccount.hasStakedNodeId() || modifiedAccount.hasStakedAccountId() || modifiedAccount.declineReward();
        }
        boolean differDeclineReward = originalAccount.declineReward() != modifiedAccount.declineReward();
        boolean differStakedNodeId = !originalAccount.stakedNodeIdOrElse(Long.valueOf(-1L)).equals(modifiedAccount.stakedNodeIdOrElse(Long.valueOf(-1L)));
        boolean differStakeAccountId = !StakingUtilities.effectiveStakedAccountId(originalAccount).equals((Object)StakingUtilities.effectiveStakedAccountId(modifiedAccount));
        return differDeclineReward || differStakedNodeId || differStakeAccountId;
    }

    private static AccountID effectiveStakedAccountId(@NonNull Account account) {
        if (account.hasStakedAccountId()) {
            return account.stakedAccountId() == null ? AccountID.DEFAULT : account.stakedAccountId();
        }
        return AccountID.DEFAULT;
    }
}

