/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.IntegerAccumulator;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import java.util.Objects;

public class VirtualMapStatistics {
    public static final String STAT_CATEGORY = "virtual_map";
    private static final String VMAP_PREFIX = "vmap_";
    private static final String QUERIES_PREFIX = "queries_";
    private static final String LIFECYCLE_PREFIX = "lifecycle_";
    private final String label;
    private LongGauge size;
    private LongAccumulator addedEntities;
    private LongAccumulator updatedEntities;
    private LongAccumulator removedEntities;
    private LongAccumulator readEntities;
    private LongGauge nodeCacheSizeB;
    private IntegerGauge pipelineSize;
    private IntegerAccumulator flushBackpressureMs;
    private IntegerAccumulator familySizeBackpressureMs;
    private LongAccumulator mergeDurationMs;
    private LongAccumulator flushDurationMs;
    private Counter flushCount;
    private LongAccumulator hashDurationMs;

    private static LongAccumulator buildLongAccumulator(Metrics metrics, String name, String description) {
        return (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config(STAT_CATEGORY, name).withInitialValue(0L).withAccumulator(Long::sum).withDescription(description));
    }

    private static IntegerAccumulator buildIntegerAccumulator(Metrics metrics, String name, String description) {
        return (IntegerAccumulator)metrics.getOrCreate((MetricConfig)new IntegerAccumulator.Config(STAT_CATEGORY, name).withInitialValue(0).withAccumulator(Integer::sum).withDescription(description));
    }

    public VirtualMapStatistics(String label) {
        Objects.requireNonNull(label, "label must not be null");
        this.label = label.replace('.', '_');
    }

    public void registerMetrics(Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.size = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(STAT_CATEGORY, "vmap_size_" + this.label).withDescription("Virtual map size, " + this.label));
        this.addedEntities = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_queries_addedEntities_" + this.label, "Added virtual map entities, " + this.label);
        this.updatedEntities = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_queries_updatedEntities_" + this.label, "Updated virtual map entities, " + this.label + ", per second");
        this.removedEntities = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_queries_removedEntities_" + this.label, "Removed virtual map entities, " + this.label + ", per second");
        this.readEntities = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_queries_readEntities_" + this.label, "Read virtual map entities, " + this.label + ", per second");
        this.nodeCacheSizeB = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config(STAT_CATEGORY, "vmap_lifecycle_nodeCacheSizeB_" + this.label).withDescription("Virtual node cache size, " + this.label + ", bytes"));
        this.pipelineSize = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config(STAT_CATEGORY, "vmap_lifecycle_pipelineSize_" + this.label).withDescription("Virtual pipeline size, " + this.label));
        this.flushBackpressureMs = VirtualMapStatistics.buildIntegerAccumulator(metrics, "vmap_lifecycle_flushBackpressureMs_" + this.label, "Virtual pipeline flush backpressure, " + this.label + ", ms");
        this.familySizeBackpressureMs = VirtualMapStatistics.buildIntegerAccumulator(metrics, "vmap_lifecycle_familySizeBackpressureMs_" + this.label, "Virtual pipeline family size backpressure, " + this.label + ", ms");
        this.mergeDurationMs = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_lifecycle_mergeDurationMs_" + this.label, "Virtual root copy merge duration, " + this.label + ", ms");
        this.flushDurationMs = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_lifecycle_flushDurationMs_" + this.label, "Virtual root copy flush duration, " + this.label + ", ms");
        this.flushCount = (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config(STAT_CATEGORY, "vmap_lifecycle_flushCount_" + this.label).withDescription("Virtual root copy flush count, " + this.label));
        this.hashDurationMs = VirtualMapStatistics.buildLongAccumulator(metrics, "vmap_lifecycle_hashDurationMs_" + this.label, "Virtual root copy hash duration, " + this.label + ", ms");
    }

    public void setSize(long size) {
        if (this.size != null) {
            this.size.set(size);
        }
    }

    public void countAddedEntities() {
        if (this.addedEntities != null) {
            this.addedEntities.update(1L);
        }
    }

    public void countUpdatedEntities() {
        if (this.updatedEntities != null) {
            this.updatedEntities.update(1L);
        }
    }

    public void countRemovedEntities() {
        if (this.removedEntities != null) {
            this.removedEntities.update(1L);
        }
    }

    public void countReadEntities() {
        if (this.readEntities != null) {
            this.readEntities.update(1L);
        }
    }

    public void setNodeCacheSize(long value) {
        if (this.nodeCacheSizeB != null) {
            this.nodeCacheSizeB.set(value);
        }
    }

    public void setPipelineSize(int value) {
        if (this.pipelineSize != null) {
            this.pipelineSize.set(value);
        }
    }

    public void recordFlushBackpressureMs(int backpressureMs) {
        if (this.flushBackpressureMs != null) {
            this.flushBackpressureMs.update(backpressureMs);
        }
    }

    public void recordFamilySizeBackpressureMs(int backpressureMs) {
        if (this.familySizeBackpressureMs != null) {
            this.familySizeBackpressureMs.update(backpressureMs);
        }
    }

    public void recordMerge(long mergeDurationMs) {
        if (this.mergeDurationMs != null) {
            this.mergeDurationMs.update(mergeDurationMs);
        }
    }

    public void recordFlush(long flushDurationMs) {
        if (this.flushCount != null) {
            this.flushCount.increment();
        }
        if (this.flushDurationMs != null) {
            this.flushDurationMs.update(flushDurationMs);
        }
    }

    public void recordHash(long hashDurationMs) {
        if (this.hashDurationMs != null) {
            this.hashDurationMs.update(hashDurationMs);
        }
    }
}

