/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.QueryContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractContractPaidQueryHandler<T>
extends PaidQueryHandler {
    protected final EntityIdFactory entityIdFactory;
    protected final Function<Query, T> operationGetter;
    protected final Function<T, ContractID> contractIdGetter;

    public AbstractContractPaidQueryHandler(@NonNull EntityIdFactory entityIdFactory, @NonNull Function<Query, T> operationGetter, @NonNull Function<T, ContractID> contractIdGetter) {
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
        this.operationGetter = Objects.requireNonNull(operationGetter);
        this.contractIdGetter = Objects.requireNonNull(contractIdGetter);
    }

    protected T getOperation(@NonNull QueryContext context) {
        return this.operationGetter.apply(context.query());
    }

    protected ContractID getContractId(@NonNull QueryContext context) {
        return this.contractIdGetter.apply(this.getOperation(context));
    }

    @Nullable
    protected Account accountFrom(@NonNull QueryContext context, @NonNull ContractID contractId) {
        ReadableAccountStore store = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        Account account = store.getContractById(contractId);
        if (account == null) {
            AccountID accountId = this.entityIdFactory.newAccountId(ConversionUtils.contractIDToNum(contractId).longValue());
            account = store.getAccountById(accountId);
        }
        return account;
    }

    @Nullable
    protected Token tokenFrom(@NonNull QueryContext context, @NonNull ContractID contractId) {
        TokenID tokenID = this.entityIdFactory.newTokenId(ConversionUtils.contractIDToNum(contractId).longValue());
        return ((ReadableTokenStore)context.createStore(ReadableTokenStore.class)).get(tokenID);
    }

    @Nullable
    protected Schedule scheduleFrom(@NonNull QueryContext context, @NonNull ContractID contractId) {
        ScheduleID scheduleId = this.entityIdFactory.newScheduleId(ConversionUtils.contractIDToNum(contractId).longValue());
        return ((ReadableScheduleStore)context.createStore(ReadableScheduleStore.class)).get(scheduleId);
    }
}

