/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public abstract class AbstractCallOperation
extends AbstractOperation {
    protected static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);

    AbstractCallOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
    }

    protected long gas(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(0));
    }

    protected abstract Address to(MessageFrame var1);

    protected abstract Wei value(MessageFrame var1);

    protected abstract Wei apparentValue(MessageFrame var1);

    protected abstract long inputDataOffset(MessageFrame var1);

    protected abstract long inputDataLength(MessageFrame var1);

    protected abstract long outputDataOffset(MessageFrame var1);

    protected abstract long outputDataLength(MessageFrame var1);

    protected abstract Address address(MessageFrame var1);

    protected abstract Address sender(MessageFrame var1);

    public abstract long gasAvailableForChildCall(MessageFrame var1);

    protected boolean isStatic(MessageFrame frame) {
        return frame.isStatic();
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        CodeV0 code;
        Wei balance;
        if (frame.stackSize() < this.getStackItemsConsumed()) {
            return UNDERFLOW_RESPONSE;
        }
        Address to = this.to(frame);
        boolean accountIsWarm = frame.warmUpAddress(to) || this.gasCalculator().isPrecompile(to);
        long cost = this.cost(frame, accountIsWarm);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.decrementRemainingGas(cost);
        frame.clearReturnData();
        Account contract = frame.getWorldUpdater().get(to);
        Account account = frame.getWorldUpdater().get(frame.getRecipientAddress());
        Wei wei = balance = account == null ? Wei.ZERO : account.getBalance();
        if (this.value(frame).compareTo((Bytes)balance) > 0 || frame.getDepth() >= 1024) {
            frame.expandMemory(this.inputDataOffset(frame), this.inputDataLength(frame));
            frame.expandMemory(this.outputDataOffset(frame), this.outputDataLength(frame));
            frame.incrementRemainingGas(this.gasAvailableForChildCall(frame) + cost);
            frame.popStackItems(this.getStackItemsConsumed());
            frame.pushStackItem(FAILURE_STACK_ITEM);
            return new Operation.OperationResult(cost, null);
        }
        MutableBytes inputData = frame.readMutableMemory(this.inputDataOffset(frame), this.inputDataLength(frame));
        Code code2 = code = contract == null ? CodeV0.EMPTY_CODE : evm.getCode(contract.getCodeHash(), contract.getCode());
        if (code.isValid()) {
            MessageFrame.builder().parentMessageFrame(frame).type(MessageFrame.Type.MESSAGE_CALL).initialGas(this.gasAvailableForChildCall(frame)).address(this.address(frame)).contract(to).inputData((Bytes)inputData).sender(this.sender(frame)).value(this.value(frame)).apparentValue(this.apparentValue(frame)).code(code).isStatic(this.isStatic(frame)).completer(child -> this.complete(frame, (MessageFrame)child)).build();
            frame.incrementRemainingGas(cost);
            frame.setState(MessageFrame.State.CODE_SUSPENDED);
            return new Operation.OperationResult(cost, null, 0);
        }
        return new Operation.OperationResult(cost, ExceptionalHaltReason.INVALID_CODE, 0);
    }

    @Deprecated(since="24.2.0", forRemoval=true)
    public long cost(MessageFrame frame) {
        return this.cost(frame, true);
    }

    public long cost(MessageFrame frame, boolean accountIsWarm) {
        long stipend = this.gas(frame);
        long inputDataOffset = this.inputDataOffset(frame);
        long inputDataLength = this.inputDataLength(frame);
        long outputDataOffset = this.outputDataOffset(frame);
        long outputDataLength = this.outputDataLength(frame);
        Account recipient = frame.getWorldUpdater().get(this.address(frame));
        Address to = this.to(frame);
        GasCalculator gasCalculator = this.gasCalculator();
        return gasCalculator.callOperationGasCost(frame, stipend, inputDataOffset, inputDataLength, outputDataOffset, outputDataLength, this.value(frame), recipient, to, accountIsWarm);
    }

    public void complete(MessageFrame frame, MessageFrame childFrame) {
        frame.setState(MessageFrame.State.CODE_EXECUTING);
        long outputOffset = this.outputDataOffset(frame);
        long outputSize = this.outputDataLength(frame);
        Bytes outputData = childFrame.getOutputData();
        if (outputSize > (long)outputData.size()) {
            frame.expandMemory(outputOffset, outputSize);
            frame.writeMemory(outputOffset, (long)outputData.size(), outputData, true);
        } else {
            frame.writeMemory(outputOffset, outputSize, outputData, true);
        }
        frame.setReturnData(outputData);
        frame.addLogs(childFrame.getLogs());
        frame.addSelfDestructs(childFrame.getSelfDestructs());
        frame.addCreates(childFrame.getCreates());
        frame.incrementGasRefund(childFrame.getGasRefund());
        long gasRemaining = childFrame.getRemainingGas();
        frame.incrementRemainingGas(gasRemaining);
        frame.popStackItems(this.getStackItemsConsumed());
        if (childFrame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
            frame.pushStackItem(SUCCESS_STACK_ITEM);
        } else {
            frame.pushStackItem(FAILURE_STACK_ITEM);
        }
        int currentPC = frame.getPC();
        frame.setPC(currentPC + 1);
    }
}

