/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.codec;

import com.hedera.hapi.block.stream.RecordFileItem;
import com.hedera.hapi.block.stream.RecordFileSignature;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.streams.SidecarFile;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RecordFileItemJsonCodec
implements JsonCodec<RecordFileItem> {
    @NonNull
    public RecordFileItem parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Timestamp temp_creation_time = null;
            Bytes temp_record_file_contents = Bytes.EMPTY;
            List temp_sidecar_file_contents = Collections.emptyList();
            List temp_record_file_signatures = Collections.emptyList();
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "creationTime": {
                        temp_creation_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block14;
                    }
                    case "recordFileContents": {
                        temp_record_file_contents = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "sidecarFileContents": {
                        temp_sidecar_file_contents = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), SidecarFile.JSON, (int)(maxDepth - 1));
                        continue block14;
                    }
                    case "recordFileSignatures": {
                        temp_record_file_signatures = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), RecordFileSignature.JSON, (int)(maxDepth - 1));
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new RecordFileItem(temp_creation_time, temp_record_file_contents, temp_sidecar_file_contents, temp_record_file_signatures);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull RecordFileItem data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.creationTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"creationTime", Timestamp.JSON, (Object)data.creationTime()));
        }
        if (data.recordFileContents() != Bytes.EMPTY && data.recordFileContents() != null && data.recordFileContents().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"recordFileContents", (Bytes)data.recordFileContents()));
        }
        if (!data.sidecarFileContents().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"sidecarFileContents", SidecarFile.JSON, data.sidecarFileContents()));
        }
        if (!data.recordFileSignatures().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"recordFileSignatures", RecordFileSignature.JSON, data.recordFileSignatures()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

