/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import java.util.Arrays;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.ConstantBytesValue;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes32;
import org.apache.tuweni.bytes.MutableBytes32;

class ConstantBytes32Value
extends AbstractBytes
implements Bytes32 {
    private final byte value;

    public ConstantBytes32Value(byte b) {
        this.value = b;
    }

    @Override
    public int size() {
        return 32;
    }

    @Override
    public byte get(int i) {
        return this.value;
    }

    @Override
    public Bytes slice(int i, int length) {
        if (length == 32) {
            return this;
        }
        return new ConstantBytesValue(this.value, length);
    }

    @Override
    public Bytes32 copy() {
        return new ConstantBytes32Value(this.value);
    }

    @Override
    public MutableBytes32 mutableCopy() {
        byte[] mutable = new byte[32];
        Arrays.fill(mutable, this.value);
        return new MutableArrayWrappingBytes32(mutable);
    }
}

