/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import java.util.Arrays;
import org.hyperledger.besu.crypto.altbn128.AbstractFieldPoint;
import org.hyperledger.besu.crypto.altbn128.AltBn128Fq2Point;
import org.hyperledger.besu.crypto.altbn128.FieldElement;
import org.hyperledger.besu.crypto.altbn128.Fq;
import org.hyperledger.besu.crypto.altbn128.Fq12;
import org.hyperledger.besu.crypto.altbn128.Fq2;

public class AltBn128Fq12Point
extends AbstractFieldPoint<AltBn128Fq12Point> {
    public static AltBn128Fq12Point g12() {
        return AltBn128Fq12Point.twist(AltBn128Fq2Point.g2());
    }

    public static AltBn128Fq12Point twist(AltBn128Fq2Point p) {
        Fq2 x = p.getX();
        Fq2 y = p.getY();
        Fq[] xCoeffs = x.getCoefficients();
        Fq[] yCoeffs = y.getCoefficients();
        Object[] nX = new Fq[12];
        Arrays.fill(nX, Fq.zero());
        nX[0] = xCoeffs[0].subtract(xCoeffs[1].multiply(9));
        nX[6] = xCoeffs[1];
        Object[] nY = new Fq[12];
        Arrays.fill(nY, Fq.zero());
        nY[0] = yCoeffs[0].subtract(yCoeffs[1].multiply(9));
        nY[6] = yCoeffs[1];
        Fq12 newX = new Fq12((Fq[])nX);
        Fq12 newY = new Fq12((Fq[])nY);
        Fq12 w = AltBn128Fq12Point.w();
        return new AltBn128Fq12Point(newX.multiply((Fq12)w.power(2)), newY.multiply((Fq12)w.power(3)));
    }

    private static Fq12 w() {
        return Fq12.create(0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public AltBn128Fq12Point(Fq12 x, Fq12 y) {
        super(x, y);
    }

    public Fq12 getX() {
        return (Fq12)this.x;
    }

    public Fq12 getY() {
        return (Fq12)this.y;
    }

    @Override
    protected AltBn128Fq12Point infinity() {
        return new AltBn128Fq12Point(Fq12.zero(), Fq12.zero());
    }

    @Override
    protected AltBn128Fq12Point newInstance(FieldElement x, FieldElement y) {
        return new AltBn128Fq12Point((Fq12)x, (Fq12)y);
    }
}

