/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.internal.observe;

import com.swirlds.base.internal.BaseTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;

public record BaseTaskDefinition(@NonNull UUID id, @NonNull String type) {
    public BaseTaskDefinition {
        Objects.requireNonNull(id, "id must not be null");
        Objects.requireNonNull(type, "type must not be null");
    }

    @NonNull
    public static BaseTaskDefinition of(@NonNull Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable must not be null");
        UUID id = UUID.randomUUID();
        if (runnable instanceof BaseTask) {
            BaseTask baseTask = (BaseTask)((Object)runnable);
            return new BaseTaskDefinition(id, baseTask.getType());
        }
        return new BaseTaskDefinition(id, "unknown");
    }

    @NonNull
    public static <V> BaseTaskDefinition of(@NonNull Callable<V> callable) {
        Objects.requireNonNull(callable, "callable must not be null");
        UUID id = UUID.randomUUID();
        if (callable instanceof BaseTask) {
            BaseTask baseTask = (BaseTask)((Object)callable);
            return new BaseTaskDefinition(id, baseTask.getType());
        }
        return new BaseTaskDefinition(id, "unknown");
    }
}

