/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fcqueue;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import java.util.Objects;

public class FCQueueStatistics {
    public static final String FCQUEUE_CATEGORY = "FCQueue";
    private static volatile boolean registered;
    private static final RunningAverageMetric.Config FCQ_ADD_EXECUTION_MICROS_CONFIG;
    private static RunningAverageMetric fcqAddExecutionMicros;
    private static final RunningAverageMetric.Config FCQ_REMOVE_EXECUTION_MICROS_CONFIG;
    private static RunningAverageMetric fcqRemoveExecutionMicros;
    private static final RunningAverageMetric.Config FCQ_HASH_EXECUTION_MICROS_CONFIG;
    private static RunningAverageMetric fcqHashExecutionMicros;

    private FCQueueStatistics() {
    }

    public static void register(Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        fcqAddExecutionMicros = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)FCQ_ADD_EXECUTION_MICROS_CONFIG);
        fcqRemoveExecutionMicros = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)FCQ_REMOVE_EXECUTION_MICROS_CONFIG);
        fcqHashExecutionMicros = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)FCQ_HASH_EXECUTION_MICROS_CONFIG);
        registered = true;
    }

    public static boolean isRegistered() {
        return registered;
    }

    public static void updateFcqAddExecutionMicros(double value) {
        if (fcqAddExecutionMicros != null) {
            fcqAddExecutionMicros.update(value);
        }
    }

    public static void updateFcqRemoveExecutionMicros(double value) {
        if (fcqRemoveExecutionMicros != null) {
            fcqRemoveExecutionMicros.update(value);
        }
    }

    public static void updateFcqHashExecutionMicros(double value) {
        if (fcqHashExecutionMicros != null) {
            fcqHashExecutionMicros.update(value);
        }
    }

    static {
        FCQ_ADD_EXECUTION_MICROS_CONFIG = new RunningAverageMetric.Config(FCQUEUE_CATEGORY, "fcqAddExecMicroSec").withDescription("avg time taken to execute the FCQueue add method, not including locks (in microseconds)").withFormat("%,9.6f");
        FCQ_REMOVE_EXECUTION_MICROS_CONFIG = new RunningAverageMetric.Config(FCQUEUE_CATEGORY, "fcqRemoveExecMicroSec").withDescription("avg time taken to execute the FCQueue remove method, not including locks (in microseconds)").withFormat("%,9.6f");
        FCQ_HASH_EXECUTION_MICROS_CONFIG = new RunningAverageMetric.Config(FCQUEUE_CATEGORY, "fcqHashExecMicroSec").withDescription("avg time taken to execute the FCQueue remove method, not including locks (in microseconds)").withFormat("%,9.6f");
    }
}

