/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.NetworkStakingRewards;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.EndOfStakingPeriodUtils;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingUtilities;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.config.data.StakingConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StakeInfoHelper {
    private static final Logger log = LogManager.getLogger(StakeInfoHelper.class);
    private static final String POST_UPGRADE_MEMO = "Post upgrade stake adjustment record";

    @Inject
    public StakeInfoHelper() {
    }

    public void increaseUnclaimedStakeRewards(@NonNull Long nodeId, long amount, @NonNull WritableStakingInfoStore stakingInfoStore) {
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(stakingInfoStore);
        StakingNodeInfo currentStakingInfo = stakingInfoStore.get(nodeId);
        long currentStakeRewardStart = currentStakingInfo.stakeRewardStart();
        long newUnclaimedStakeRewardStart = currentStakingInfo.unclaimedStakeRewardStart() + amount;
        StakingNodeInfo.Builder newStakingInfo = currentStakingInfo.copyBuilder();
        if (newUnclaimedStakeRewardStart > currentStakeRewardStart) {
            log.warn("Asked to release {} more rewards for node{} (now {}), but only {} was staked", (Object)amount, (Object)nodeId, (Object)newUnclaimedStakeRewardStart, (Object)currentStakeRewardStart);
            newStakingInfo.unclaimedStakeRewardStart(currentStakeRewardStart);
        } else {
            newStakingInfo.unclaimedStakeRewardStart(newUnclaimedStakeRewardStart);
        }
        stakingInfoStore.put(nodeId, newStakingInfo.build());
    }

    public void awardStake(@NonNull Long nodeId, @NonNull Account account, @NonNull WritableStakingInfoStore stakingInfoStore) {
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(account);
        Objects.requireNonNull(stakingInfoStore);
        long stakeToAward = StakingUtilities.roundedToHbar(StakingUtilities.totalStake(account));
        boolean isDeclineReward = account.declineReward();
        StakingNodeInfo stakingInfo = stakingInfoStore.get(nodeId);
        if (stakingInfo != null) {
            StakingNodeInfo.Builder copy = stakingInfo.copyBuilder();
            if (isDeclineReward) {
                long stakedToNotReward = stakingInfo.stakeToNotReward() + stakeToAward;
                copy.stakeToNotReward(stakedToNotReward);
            } else {
                long stakedToReward = stakingInfo.stakeToReward() + stakeToAward;
                copy.stakeToReward(stakedToReward);
            }
            stakingInfoStore.put(nodeId, copy.build());
        } else {
            log.error("Staking info is null for node {}", (Object)nodeId);
        }
    }

    public void withdrawStake(@NonNull Long nodeId, @NonNull Account account, @NonNull WritableStakingInfoStore stakingInfoStore) {
        Objects.requireNonNull(nodeId);
        Objects.requireNonNull(account);
        Objects.requireNonNull(stakingInfoStore);
        long stakeToWithdraw = StakingUtilities.roundedToHbar(StakingUtilities.totalStake(account));
        boolean isDeclineReward = account.declineReward();
        StakingNodeInfo stakingInfo = stakingInfoStore.get(nodeId);
        StakingNodeInfo.Builder copy = Objects.requireNonNull(stakingInfo).copyBuilder();
        if (isDeclineReward) {
            long stakedToNotReward = stakingInfo.stakeToNotReward() - stakeToWithdraw;
            if (stakedToNotReward < 0L) {
                log.warn("Asked to withdraw {} more unrewarded stake for node{} (now {}), but only {} was staked to not reward", (Object)stakeToWithdraw, (Object)nodeId, (Object)stakedToNotReward, (Object)stakingInfo.stakeToNotReward());
            }
            copy.stakeToNotReward(Math.max(0L, stakedToNotReward));
        } else {
            long stakeToReward = stakingInfo.stakeToReward() - stakeToWithdraw;
            if (stakeToReward < 0L) {
                log.warn("Asked to withdraw {} more rewarded stake for node{} (now {}), but only {} was staked to reward", (Object)stakeToWithdraw, (Object)nodeId, (Object)stakeToReward, (Object)stakingInfo.stakeToReward());
            }
            copy.stakeToReward(Math.max(0L, stakeToReward));
        }
        stakingInfoStore.put(nodeId, copy.build());
    }

    public void adjustPostUpgradeStakes(@NonNull NetworkInfo networkInfo, @NonNull Configuration config, @NonNull WritableStakingInfoStore infoStore, @NonNull WritableNetworkStakingRewardsStore rewardsStore) {
        Objects.requireNonNull(infoStore);
        Objects.requireNonNull(networkInfo);
        Objects.requireNonNull(config);
        Objects.requireNonNull(rewardsStore);
        Set<Long> preUpgradeNodeIds = infoStore.getAll();
        preUpgradeNodeIds.stream().sorted().forEach(nodeId -> {
            StakingNodeInfo stakingInfo = Objects.requireNonNull(infoStore.get((long)nodeId));
            if (!networkInfo.containsNode(nodeId.longValue()) && !stakingInfo.deleted()) {
                infoStore.put((long)nodeId, stakingInfo.copyBuilder().weight(0).deleted(true).build());
                log.info("Marked node{} as deleted since it has been removed from the address book", nodeId);
                NetworkStakingRewards rewards = EndOfStakingPeriodUtils.asStakingRewardBuilder(rewardsStore).pendingRewards(rewardsStore.pendingRewards() - stakingInfo.pendingRewards()).build();
                rewardsStore.put(rewards);
            }
        });
        this.completeUpdateFromNewAddressBook(infoStore, networkInfo.addressBook(), config);
    }

    private void completeUpdateFromNewAddressBook(@NonNull WritableStakingInfoStore store, @NonNull List<NodeInfo> nodeInfos, @NonNull Configuration config) {
        StakingConfig stakingConfig = (StakingConfig)config.getConfigData(StakingConfig.class);
        int numRewardHistoryStoredPeriods = stakingConfig.rewardHistoryNumStoredPeriods();
        long maxStakePerNode = stakingConfig.maxStake();
        for (NodeInfo nodeId : nodeInfos) {
            StakingNodeInfo stakingInfo = store.get(nodeId.nodeId());
            if (stakingInfo != null) {
                if (stakingInfo.maxStake() == maxStakePerNode) continue;
                store.put(nodeId.nodeId(), stakingInfo.copyBuilder().maxStake(maxStakePerNode).build());
                continue;
            }
            StakingNodeInfo newNodeStakingInfo = StakingNodeInfo.newBuilder().nodeNumber(nodeId.nodeId()).maxStake(maxStakePerNode).minStake(stakingConfig.minStake()).rewardSumHistory((Long[])Collections.nCopies(numRewardHistoryStoredPeriods + 1, 0L).toArray(Long[]::new)).weight(0).build();
            store.putAndIncrementCount(nodeId.nodeId(), newNodeStakingInfo);
        }
    }
}

