/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.info;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.entity.EntityCounts;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.node.app.info.NodeInfoImpl;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StateNetworkInfo
implements NetworkInfo {
    private static final Logger log = LogManager.getLogger(StateNetworkInfo.class);
    private final long selfId;
    private final Bytes ledgerId;
    private final Roster activeRoster;
    private final Supplier<Network> genesisNetworkSupplier;
    private volatile Map<Long, NodeInfo> nodeInfos;
    private final Configuration configuration;

    public StateNetworkInfo(long selfId, @NonNull State state, @NonNull Roster roster, @NonNull ConfigProvider configProvider, @NonNull Supplier<Network> genesisNetworkSupplier) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(configProvider);
        this.activeRoster = Objects.requireNonNull(roster);
        this.genesisNetworkSupplier = Objects.requireNonNull(genesisNetworkSupplier);
        this.configuration = configProvider.getConfiguration();
        this.ledgerId = ((LedgerConfig)configProvider.getConfiguration().getConfigData(LedgerConfig.class)).id();
        this.nodeInfos = this.nodeInfosFrom(state);
        this.selfId = selfId;
    }

    @NonNull
    public Bytes ledgerId() {
        return this.ledgerId;
    }

    @NonNull
    public NodeInfo selfNodeInfo() {
        return this.nodeInfos.get(this.selfId);
    }

    @NonNull
    public List<NodeInfo> addressBook() {
        return List.copyOf(this.nodeInfos.values());
    }

    @Nullable
    public NodeInfo nodeInfo(long nodeId) {
        return this.nodeInfos.get(nodeId);
    }

    public boolean containsNode(long nodeId) {
        return this.nodeInfos.containsKey(nodeId);
    }

    public void updateFrom(@NonNull State state) {
        this.nodeInfos = this.nodeInfosFrom(state);
    }

    private Map<Long, NodeInfo> nodeInfosFrom(@NonNull State state) {
        ReadableSingletonState entityCounts = state.getReadableStates("EntityIdService").getSingleton("ENTITY_COUNTS");
        LinkedHashMap<Long, NodeInfo> nodeInfos = new LinkedHashMap<Long, NodeInfo>();
        if (Objects.requireNonNull((EntityCounts)entityCounts.get()).numNodes() == 0L) {
            Network network = this.genesisNetworkSupplier.get();
            for (NodeMetadata metadata : network.nodeMetadata()) {
                Node node = metadata.nodeOrThrow();
                NodeInfoImpl nodeInfo = new NodeInfoImpl(node.nodeId(), node.accountIdOrThrow(), node.weight(), node.gossipEndpoint(), node.gossipCaCertificate(), node.serviceEndpoint(), node.declineReward(), node.grpcCertificateHash().length() > 0L ? node.grpcCertificateHash() : null);
                nodeInfos.put(node.nodeId(), nodeInfo);
            }
        } else {
            ReadableKVState nodes = state.getReadableStates("AddressBookService").get("NODES");
            HederaConfig hederaConfig = (HederaConfig)this.configuration.getConfigData(HederaConfig.class);
            for (RosterEntry rosterEntry : this.activeRoster.rosterEntries()) {
                Node node = (Node)nodes.get((Object)new EntityNumber(rosterEntry.nodeId()));
                if (node != null) {
                    nodeInfos.put(rosterEntry.nodeId(), NodeInfoImpl.fromRosterWithCurrentMetadata(rosterEntry, node));
                    continue;
                }
                nodeInfos.put(rosterEntry.nodeId(), NodeInfoImpl.fromRosterEntry(rosterEntry, AccountID.newBuilder().shardNum(hederaConfig.shard()).realmNum(hederaConfig.realm()).accountNum(rosterEntry.nodeId() + 3L).build()));
                log.error("Roster includes a node {} that is not found in node store", (Object)rosterEntry.nodeId());
            }
        }
        return Collections.unmodifiableMap(nodeInfos);
    }
}

