/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.metrics;

import com.hedera.node.app.metrics.StoreMetricsImpl;
import com.hedera.node.app.spi.metrics.StoreMetricsService;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.spi.metrics.StoreMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class StoreMetricsServiceImpl
implements StoreMetricsService {
    private final Map<StoreMetricsService.StoreType, StoreMetricsImpl> storeMetricsMap = new EnumMap<StoreMetricsService.StoreType, StoreMetricsImpl>(StoreMetricsService.StoreType.class);

    public StoreMetricsServiceImpl(@NonNull Metrics metrics) {
        this.storeMetricsMap.put(StoreMetricsService.StoreType.TOPIC, new StoreMetricsImpl(metrics, "topics"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.ACCOUNT, new StoreMetricsImpl(metrics, "accounts"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.AIRDROP, new StoreMetricsImpl(metrics, "airdrops"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.NFT, new StoreMetricsImpl(metrics, "nfts"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.TOKEN, new StoreMetricsImpl(metrics, "tokens"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.TOKEN_RELATION, new StoreMetricsImpl(metrics, "tokenAssociations", "token associations"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.FILE, new StoreMetricsImpl(metrics, "files"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.SLOT_STORAGE, new StoreMetricsImpl(metrics, "storageSlots", "storage slots"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.CONTRACT, new StoreMetricsImpl(metrics, "contracts"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.SCHEDULE, new StoreMetricsImpl(metrics, "schedules"));
        this.storeMetricsMap.put(StoreMetricsService.StoreType.NODE, new StoreMetricsImpl(metrics, "nodes"));
    }

    public StoreMetrics get(@NonNull StoreMetricsService.StoreType storeType, long capacity) {
        StoreMetricsImpl metric = this.storeMetricsMap.get(storeType);
        metric.updateCapacity(capacity);
        return metric;
    }
}

