/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V0490BlockRecordSchema
extends Schema {
    private static final Logger logger = LogManager.getLogger(V0490BlockRecordSchema.class);
    public static final String RUNNING_HASHES_STATE_KEY = "RUNNING_HASHES";
    public static final String BLOCK_INFO_STATE_KEY = "BLOCKS";
    private static final Bytes GENESIS_HASH = Bytes.wrap((byte[])new byte[48]);
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();

    public V0490BlockRecordSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((String)RUNNING_HASHES_STATE_KEY, (Codec)RunningHashes.PROTOBUF), StateDefinition.singleton((String)BLOCK_INFO_STATE_KEY, (Codec)BlockInfo.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        if (ctx.isGenesis()) {
            WritableSingletonState blocksState = ctx.newStates().getSingleton(BLOCK_INFO_STATE_KEY);
            BlockInfo blocks = new BlockInfo(-1L, BlockRecordService.EPOCH, Bytes.EMPTY, BlockRecordService.EPOCH, true, BlockRecordService.EPOCH, BlockRecordService.EPOCH, BlockRecordService.EPOCH);
            blocksState.put((Object)blocks);
            WritableSingletonState runningHashState = ctx.newStates().getSingleton(RUNNING_HASHES_STATE_KEY);
            RunningHashes runningHashes = RunningHashes.newBuilder().runningHash(GENESIS_HASH).build();
            runningHashState.put((Object)runningHashes);
        }
    }
}

