/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.roster.codec;

import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RosterStateJsonCodec
implements JsonCodec<RosterState> {
    @NonNull
    public RosterState parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_candidate_roster_hash = Bytes.EMPTY;
            List temp_round_roster_pairs = Collections.emptyList();
            boolean temp_transplant_in_progress = false;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "candidateRosterHash": {
                        temp_candidate_roster_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "roundRosterPairs": {
                        temp_round_roster_pairs = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), RoundRosterPair.JSON, (int)(maxDepth - 1));
                        continue block12;
                    }
                    case "transplantInProgress": {
                        temp_transplant_in_progress = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new RosterState(temp_candidate_roster_hash, temp_round_roster_pairs, temp_transplant_in_progress);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull RosterState data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.candidateRosterHash() != Bytes.EMPTY && data.candidateRosterHash() != null && data.candidateRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"candidateRosterHash", (Bytes)data.candidateRosterHash()));
        }
        if (!data.roundRosterPairs().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"roundRosterPairs", RoundRosterPair.JSON, data.roundRosterPairs()));
        }
        if (data.transplantInProgress()) {
            fieldLines.add(JsonTools.field((String)"transplantInProgress", (boolean)data.transplantInProgress()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

